#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import ShowCommand
import CliPlugin.StorageDevicesCli as StorageDevicesCli
from CliPlugin.StorageDevicesModels import Devices
from CliToken.System import systemMatcherForShow

#--------------------------------------------------------------------------------
# show system health storage
#--------------------------------------------------------------------------------
class SystemHealthStorageCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show system health storage'
   data = {
      'system': systemMatcherForShow,
      'health': 'Show the health of system components',
      'storage': 'Show the health of mounted storage devices',
   }
   handler = StorageDevicesCli.showSystemHealthStorage
   cliModel = Devices

BasicCli.addShowCommandClass( SystemHealthStorageCmd )
