# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliModel

class EmmcLifetime( CliModel.Model ):
   slcWearLevel = CliModel.Float( help='SLC region fractional design wear remaining',
                                  optional=True )
   mlcWearLevel = CliModel.Float( help='MLC region fractional design wear remaining',
                                  optional=True )
   reservesLevel = CliModel.Float( help='Reserve block fractional level remaining',
                                   optional=True )

class SmartHealth( CliModel.Model ):
   wearLevel = CliModel.Float( help='Percent design lifetime wear remaining',
                               optional=True )
   reallocationsRemaining = CliModel.Float(
                                       help='Fractional unused reallocations blocks',
                                       optional=True )
   health = CliModel.Str( help='Overall device health', optional=True )

class StorageHealth( CliModel.Model ):
   emmc = CliModel.Submodel( help='eMMC lifetimes attributes', optional=True,
                             valueType=EmmcLifetime )
   smart = CliModel.Submodel( help='S.M.A.R.T. health attributes', optional=True,
                          valueType=SmartHealth )

class Devices( CliModel.Model ):
   devices = CliModel.Dict( help='Storage devices', valueType=StorageHealth )

   def render( self ):
      print 'eMMC:\n'

      print 'File System SLC Remaining MLC Remaining Reserves Remaining'
      print '----------- ------------- ------------- ------------------'
      for name, device in sorted( self.devices.items() ):
         if device.emmc is None:
            continue

         info = device.emmc

         slc = 'N/A'
         if info.slcWearLevel is not None:
            slc = '%.0f%%' % ( info.slcWearLevel * 100.0 )
         mlc = 'N/A'
         if info.mlcWearLevel is not None:
            mlc = '%.0f%%' % ( info.mlcWearLevel * 100.0 )
         reserves = 'N/A'
         if info.reservesLevel is not None:
            reserves = '%.0f%%' % ( info.reservesLevel * 100.0 )

         print '%-11s %-13s %-13s %s' % ( name + ':', slc, mlc, reserves )

      print '\nSMART:\n'


      print 'File System Wear Remaining Reallocations Remaining Health'
      print '----------- -------------- ----------------------- ------'
      for name, device in sorted( self.devices.items() ):
         if device.smart is None:
            continue

         info = device.smart

         wear = 'N/A'
         if info.wearLevel is not None:
            wear = '%.0f%%' % ( info.wearLevel * 100.0 )
         reserves = 'N/A'
         if info.reallocationsRemaining is not None:
            reserves = '%.0f%%' % ( info.reallocationsRemaining * 100.0 )
         health = 'N/A'
         if info.health is not None:
            health = info.health

         print '%-11s %-14s %-23s %s' % ( name + ':', wear, reserves, health )
