# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

"""This module implements the 'show startup-config errors' command, which displays
the details of the errors found in startup-config."""

import BasicCli
import EosInit
import FileCli
import LazyMount
import ShowCommand
import Tac
import Url
from UrlPlugin.FlashUrl import flashFileUrl
import os

sysdbStatus = None

def checkIfStartupConfigExists():
   startupConfig = flashFileUrl( "startup-config" )
   urlContext = Url.Context( None, disableAaa=True )
   startupUrl = Url.parseUrl( startupConfig, urlContext )
   #pylint:disable=maybe-no-member
   return os.path.exists( startupUrl.localFilename() )

class ShowStartupConfigErrors( ShowCommand.ShowCliCommandClass ):
   syntax = "show startup-config errors"
   data = {
      "startup-config" : FileCli.startupConfigAfterShowKw,
      "errors" : 'Show information about the errors in startup-config'
   }
   privileged = True

   @staticmethod
   def handler( mode, args ):
      if checkIfStartupConfigExists():
         if sysdbStatus.startupConfigErrorCount > 0:
            print 'Total %d errors found in startup-config.\n' \
               % sysdbStatus.startupConfigErrorCount
            try:
               print file( EosInit.startupConfigOutputPath ).read()
            except IOError:
               # This can happen on SSO standby
               mode.addError( "Cannot retrieve errors" )
         else:
            print 'No errors were found in startup-config.'
      else:
         mode.addError( "Error: startup-config file does not exist" )

BasicCli.addShowCommandClass( ShowStartupConfigErrors )

def Plugin( entityManager ):
   global sysdbStatus
   sysdbStatus = LazyMount.mount( entityManager, "Sysdb/status", 
                                  "Sysdb::Status", "r" )
