#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from ArnetModel import IpGenericAddress
from CliModel import (
   List,
   Model,
)
from IntfModels import Interface

# Though this is very similar to TunnelModels.MplsVia, we are deliberately not
# using that type here. This is because the fact that segment lists are currently
# using Tunnels to propagate their data to platform is not relevant to the user,
# and this implementation could be changed at any time, so there is no reason that
# this model should be tethered to tunnels.
class SrTeSegmentListVia( Model ):
   nexthop = IpGenericAddress( help="Next hop IP address" )
   interface = Interface( help="Egress L3 interface of the next hop" )
   mplsLabels = List( valueType=int, optional=True, help="MPLS label stack" )
