
#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
import CliParser, BasicCli
import ConfigMount, LazyMount
import CliToken.Mac
from CliPlugin.BridgingCliModel import MacSourceCheckSystemMac
from CliPlugin.BridgingCliModel import MacSourceCheckInvalid
import ShowCommand
import CliCommand

cliConfig = None
bridgingHwCapabilities = None

def invalidAndBridgeSmacPktSwitchSupportedGuard( mode, token ):
   if bridgingHwCapabilities.invalidAndBridgeSmacPktSwitchSupported:
      return None
   else:
      return CliParser.guardNotThisPlatform

def doShowSourceMacSameAsCPU( mode, args ):
   return MacSourceCheckSystemMac( sourceCheckCPUMac=cliConfig.sourceCheckCPUMac )

def doShowSourceMacInvalid( mode, args ):
   return MacSourceCheckInvalid( sourceCheckInvalid=cliConfig.sourceMacInvalid )

sourceCheck = CliCommand.guardedKeyword( 'source-check',
      helpdesc='Check source address',
      guard=invalidAndBridgeSmacPktSwitchSupportedGuard )
systemMac = CliCommand.guardedKeyword( 'system-mac',
      helpdesc='System mac/bridge mac',
      guard=invalidAndBridgeSmacPktSwitchSupportedGuard )
defaultNode = CliCommand.guardedKeyword( 'default',
      helpdesc='Default',
      guard=invalidAndBridgeSmacPktSwitchSupportedGuard )
disabledNode = CliCommand.guardedKeyword( 'disabled',
      helpdesc='Disable functionality',
      guard=invalidAndBridgeSmacPktSwitchSupportedGuard )
invallidNode = CliCommand.guardedKeyword( 'invalid',
      helpdesc='Invalid source address',
      guard=invalidAndBridgeSmacPktSwitchSupportedGuard )

class SourceMacSameAsCPUCmd( CliCommand.CliCommandClass ):
   syntax = 'mac source-check system-mac default [ disabled ]'
   data = {
      'mac': CliToken.Mac.macMatcherForConfig,
      'source-check': sourceCheck,
      'system-mac': systemMac,
      'default': defaultNode,
      'disabled': disabledNode,
      }

   @staticmethod
   def handler( mode, args ):
      cliConfig.sourceCheckCPUMac = 'disabled' not in args 

BasicCli.GlobalConfigMode.addCommandClass( SourceMacSameAsCPUCmd )

class SourceMacInvalidCmd( CliCommand.CliCommandClass ):
   syntax = 'mac source-check invalid default [ disabled ]'
   data = {
      'mac': CliToken.Mac.macMatcherForConfig,
      'source-check': sourceCheck,
      'invalid': invallidNode,
      'default': defaultNode,
      'disabled': disabledNode,
      }

   @staticmethod
   def handler( mode, args ):
      cliConfig.sourceMacInvalid = 'disabled' not in args 

BasicCli.GlobalConfigMode.addCommandClass( SourceMacInvalidCmd )

class SourceSystemMacCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show mac source-check system-mac'
   data = {
      'mac': CliToken.Mac.macMatcherForShow,
      'source-check': sourceCheck,
      'system-mac': systemMac,
      }

   cliModel = MacSourceCheckSystemMac
   handler = doShowSourceMacSameAsCPU

BasicCli.addShowCommandClass( SourceSystemMacCmd )

class SourceCheckInvalidCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show mac source-check invalid'
   data = {
      'mac': CliToken.Mac.macMatcherForShow,
      'source-check': sourceCheck,
      'invalid': invallidNode,
      }

   cliModel = MacSourceCheckInvalid
   handler = doShowSourceMacInvalid

BasicCli.addShowCommandClass( SourceCheckInvalidCmd )

def Plugin( entityManager ):
   global cliConfig
   global bridgingHwCapabilities

   cliConfig = ConfigMount.mount( entityManager, "bridging/input/config/cli",
                                  "Bridging::Input::CliConfig", "w" )
   bridgingHwCapabilities = LazyMount.mount( entityManager,
                                             "bridging/hwcapabilities",
                                             "Bridging::HwCapabilities", "r" )
