# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
from CliToken.Debugging import debuggingMatcherForShow
import CliPlugin.SmashCli as SmashCli
import ShowCommand

#--------------------------------------------------------------------------------
# show debugging smash clients all
#--------------------------------------------------------------------------------
class SmashClientsAllCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show debugging smash clients all'
   data = {
      'debugging' : debuggingMatcherForShow,
      'smash' : 'Show information about Smash tables',
      'clients' : 'Show the clients of Smash tables',
      'all' : 'Show information for all Smash tables',
   }
   handler = SmashCli.showSmashClientsAll
   privileged = True

BasicCli.addShowCommandClass( SmashClientsAllCmd )
