# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import Tac
import sys
import SmashUtils

def showSmashClientsAll( mode, args ):
   try:
      # run smash scanner to print all the clients. Note that we need to run this
      # command as root for meaningful information to be displayed.
      Tac.run( SmashUtils.smashWhoAll(), stdout=sys.stdout, stderr=sys.stderr,
            asRoot=True )

   except Tac.SystemCommandError:
      mode.addError( 'Error printing smash clients' )
