#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import sys

# In a file of its own, to allow functions defined to be imported by
# other packages with minmal dependencies required.

def showTaskSchedulerJsonToModel( jsonTxt, paramDebug, rethrowDecodeError=False ):
   import simplejson
   from CliPlugin import ShowTaskSchedulerModel
   from CliModel import unmarshalModel
   try:
      j = simplejson.loads( jsonTxt )
   except simplejson.JSONDecodeError:
      if rethrowDecodeError:
         raise
      return None
   ret = unmarshalModel( ShowTaskSchedulerModel.Overall, j, degraded=False )
   ret._debug = paramDebug           # pylint: disable-msg=protected-access
   ret._flatten = True               # pylint: disable-msg=protected-access
   return ret

def showTaskSchedulerJsonToRenderedTxt( jsonTxt, paramDebug ):
   class InterceptStdout( object ):
      def __init__( self ):
         from StringIO import StringIO
         self.oldStdout = sys.stdout
         self.wrappedStdOut = StringIO()
         sys.stdout = self.wrappedStdOut

      def __del__( self ):
         self.restoreStdout()

      def restoreStdout( self ):
         sys.stdout = self.oldStdout

      def getOutput( self ):
         return self.wrappedStdOut.getvalue()

   model = showTaskSchedulerJsonToModel( jsonTxt, paramDebug,
                                         rethrowDecodeError=True )
   assert model is not None
   interceptStdout = InterceptStdout()
   model.render()
   return interceptStdout.getOutput()
