# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ArPyUtils
import BasicCli
import CliMatcher
import LazyMount
import ShowCommand
import Tac
from CliPlugin import TechSupportCli
from TableOutput import createTable, Format

hwLedConfig = None
tokenLedHelpDesc = 'Show LED Information'

# -----------------------------------------------------------------------------
# show led [ name NAME ]
#
# Shows the lightSetting values of leds
# -----------------------------------------------------------------------------
class ShowLedSettings( ShowCommand.ShowCliCommandClass ):
   syntax = 'show led [ name NAME ]'
   data = {
      'led': tokenLedHelpDesc,
      'name': 'Show LED Light Settings by name',
      'NAME': CliMatcher.PatternMatcher( pattern=r'.+',
                                         helpdesc='LED name',
                                         helpname='WORD' ),
   }

   @staticmethod
   def handler( mode, args ):
      hwLeds = hwLedConfig.leds
      if not hwLeds:
         print "No LEDs found"
         return

      name = args.get( 'NAME' )
      if name:
         lower = name.lower()
         # Check for led name match
         ledNames = [ led for led in hwLeds if led.lower() == lower ]
         if not ledNames:
            print "%s LED not found" % name
            return
      else:
         ledNames = hwLeds

      # Table Formatting
      columns = ( 'Name', 'Red', 'Green', 'Blue', 'Yellow', 'Status',
                  ( 'Flash', ( 'Rate', ) ),
                  ( 'Brightness',  ( 'Max', 'Min' ) ) )
      table = createTable( columns )
      fl = Format( justify="left" )
      table.formatColumns( *( fl for _ in columns ) )
      # Getting the values of each row
      boolMapper = [ "off", "on" ]
      for led in ArPyUtils.naturalsorted( ledNames ):
         settings = hwLeds[ led ].lightSetting
         name = led
         red = boolMapper[ settings.red ]
         green = boolMapper[ settings.green ]
         blue = boolMapper[ settings.blue ]
         yellow = boolMapper[ settings.yellow ]
         status = str( settings.plutoStatus ).lower()
         status = status.replace( 'plutostatus', '' )
         flashRate = str( settings.flashRate ).lower()
         maxBright = str( settings.maxBright )
         minBright = str( settings.minBright )
         table.newRow( name, red, green, blue, yellow, status,
                       flashRate, maxBright, minBright )
      print table.output()

BasicCli.addShowCommandClass( ShowLedSettings )

_showTechCmds = lambda : [ 'show led' ]
timeStamp = '2019-02-26 16:35:00'
TechSupportCli.registerShowTechSupportCmdCallback( timeStamp, _showTechCmds )

# -----------------------------------------------------------------------------
# Cli Plugin initialization
# -----------------------------------------------------------------------------
def Plugin( entityManager ):
   global hwLedConfig
   hwLedConfig = LazyMount.mount( entityManager, "hardware/led/config",
                                  "Hardware::Led::LedSystemConfigDir", "r" )

