#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli, ShowCommand, CliMatcher
from CliToken.Debugging import debuggingMatcherForShow
import Tac
import sys

ALL_QUERIES = {
   'count' : 'Show the number of inotify fds in use',
   'limits' : 'Show inotify system limits',
   'ps' : 'Show processes using inotify',
   'user' : 'Show how many inotify fds each user is using',
}

class InotifyShowCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show debugging inotify ( QUERY | all )'
   data = {
      'debugging' : debuggingMatcherForShow,
      'inotify' : 'Show inotify usage information',
      'QUERY' : CliMatcher.EnumMatcher( ALL_QUERIES ),
      'all' : 'Run all the inotify subcommands',
   }
   privileged = True

   @staticmethod
   def handler( mode, args ):
      queries = ALL_QUERIES if 'all' in args else [ args[ 'QUERY' ] ]
      for query in queries:
         try:
            # only print the section header for the 'all' command
            if 'all' in args:
               print( '\n----- show debugging inotify ' + query + ' -----\n' )
               sys.stdout.flush()
            Tac.run( [ 'inotify-query', query ], asRoot=True )
         except Tac.SystemCommandError as e:
            mode.addError( 'Failed to run command %s. got status: %u output: %s'
                           % ( query, e.error, e.output ) )

BasicCli.addShowCommandClass( InotifyShowCmd ) 
