# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import LazyMount
import Tracing
import CliPlugin.TechSupportCli
from CliPlugin.FlowTrackingCliLib import isSftAgentRunning

__defaultTraceHandle__ = Tracing.Handle( 'SftShowTech' )
t0 = Tracing.trace0

activeAgentDir = None
entityManager = None

# Register flow tracking Cli commands with 'show tech support'.
def _sftShowTechCmds():
   # Ensure SftAgent is running before issuing commands for it
   if isSftAgentRunning( entityManager, activeAgentDir ):
      cmds = [
         'show flow tracking sampled',
         'show flow tracking sampled counters',
         ]
      return cmds
   t0( 'SftAgent is not running' )
   return []

CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback(
      '2019-01-16 16:10:20', _sftShowTechCmds )

def Plugin( em ):
   global activeAgentDir
   global entityManager
   entityManager = em
   activeAgentDir = LazyMount.mount( em, 'flowtracking/activeAgent',
                                     'Tac::Dir', 'ri' )
