# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliMatcher
import CliPlugin.IpAddrMatcher as IpAddrMatcher
from CliPlugin.VrfCli import getAllPlusReservedVrfNames
from FlowTrackingCliLib import guardSampledHwOffload
from FlowTrackerCliUtil import ftrTypeSampled
from Intf.IntfRange import IntfRangeMatcher
import Ip6AddrMatcher
import Smash
from SftCliUtil import HoFlowStateEnum
from TypeFuture import TacLazyType

IpProtoType = TacLazyType( 'Arnet::IpProtocolNumber' )

tokenSrcIp = CliMatcher.KeywordMatcher( 'src-ip', "Flow source IP address" )

tokenDstIp = CliMatcher.KeywordMatcher( 'dst-ip', "Flow destination IP address" )

tokenIPv4 = CliCommand.Node( IpAddrMatcher.IpAddrMatcher( helpdesc='IPv4 address' ),
                             maxMatches=1 )

tokenIPv6 = CliCommand.Node(
                        Ip6AddrMatcher.Ip6AddrMatcher( helpdesc='IPv6 address' ),
                        maxMatches=1 )

tokenSrcPort = CliMatcher.KeywordMatcher( 'src-port', "Flow source port" )

tokenDstPort = CliMatcher.KeywordMatcher( 'dst-port', "Flow destination port" )

tokenPort = CliCommand.Node( CliMatcher.IntegerMatcher( 0, 65535,
                                                        helpdesc='IP port' ),
                             maxMatches=1 )

tokenVrf = CliMatcher.KeywordMatcher( 'vrf', "Flow VRF" )

tokenVrfValue = CliCommand.Node(
                        CliMatcher.DynamicNameMatcher( getAllPlusReservedVrfNames,
                                                       "VRF", passContext=True ),
                         maxMatches=1 )

tokenVlan = CliMatcher.KeywordMatcher( 'vlan', "Flow VLAN ID" )

tokenVlanValue = CliCommand.Node( CliMatcher.IntegerMatcher( 0, 4094,
                                       helpdesc='Identifier for a Virtual LAN' ),
                                  maxMatches=1 )

protocols = [ ( p[ len( 'ipProto' ) : ] if p.startswith( 'ipProto' ) else p )
              for p in IpProtoType.attributes ]

tokenProtocol = CliMatcher.KeywordMatcher( 'protocol', "Flow IP protocol" )

tokenProtocolValue = CliCommand.Node( CliMatcher.DynamicNameMatcher( protocols,
                                                                "IP protocol",
                                                                passContext=True ),
                                      maxMatches=1 )

tokenInterface = CliMatcher.KeywordMatcher( 'interface', "ingress interface" )

tokenState = CliMatcher.KeywordMatcher( 'state', "Hardware offload flow state" )

hoFlowStateShowStr = {
   HoFlowStateEnum.hoFlowStateUnknown : 'unknown',
   HoFlowStateEnum.inHardware : 'active',
   HoFlowStateEnum.inProgress : 'in-progress',
   HoFlowStateEnum.outOfResources : 'hw-limit',
}

tokenStateValue = CliCommand.Node(
                        CliMatcher.DynamicNameMatcher( hoFlowStateShowStr.values,
                                                       "Flow state",
                                                       passContext=True ),
                         maxMatches=1 )

intfRangeRule = CliCommand.Node( IntfRangeMatcher(), maxMatches=1 )

sampledHardwareKw = CliCommand.guardedKeyword( 'hardware', helpdesc='Hardware',
                                            guard=guardSampledHwOffload )

def getFlowTable( shmemEm, trackerName ):
   mountPath = 'flowtracking/%s/flowTable/%s' % ( ftrTypeSampled, trackerName )
   entityType = 'FlowTracking::FlowTable'
   smashFlowTable = shmemEm.doMount( mountPath, entityType,
                                     Smash.mountInfo( 'reader' ) )
   return smashFlowTable
