#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import CliCommand
import CliMatcher
import CliPlugin.SflowCli as SflowCli
from CliPlugin.SflowModel import SflowInterfaces, SflowStatus
import ShowCommand

matcherSflow = CliMatcher.KeywordMatcher( 'sflow',
      helpdesc='sFlow Information' )
nodeSflow = CliCommand.Node( matcher=matcherSflow,
      guard=SflowCli.sflowSupportedGuard )

#--------------------------------------------------------------------------------
# show sflow
#--------------------------------------------------------------------------------
class SflowCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show sflow [ detail ]'
   data = {
      'sflow' : nodeSflow,
      'detail' : 'Detailed sFlow information',
   }
   handler = SflowCli.doShowSflow
   cliModel = SflowStatus
   prepareFunction = SflowCli.doPrepShowSflow

BasicCli.addShowCommandClass( SflowCmd )

#--------------------------------------------------------------------------------
# show sflow interfaces
#--------------------------------------------------------------------------------
class SflowInterfacesCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show sflow interfaces'
   data = {
      'sflow' : nodeSflow,
      'interfaces' : 'Show sFlow interfaces',
   }
   handler = SflowCli.doShowSflowIntfs
   cliModel = SflowInterfaces

BasicCli.addShowCommandClass( SflowInterfacesCmd )
