#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.SflowCli as SflowCli
from CliToken.Clear import clearKwNode

#--------------------------------------------------------------------------------
# clear sflow counters
#--------------------------------------------------------------------------------
class ClearSflowCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear sflow counters'
   data = {
      'clear' : clearKwNode,
      'sflow' : CliCommand.Node(
         matcher=CliMatcher.KeywordMatcher( 'sflow',
            helpdesc='Clear sFlow information' ),
         guard=SflowCli.sflowSupportedGuard ),
      'counters' : 'Clear sFlow global counters',
   }
   handler = SflowCli.setCountersCleared

BasicCliModes.EnableMode.addCommandClass( ClearSflowCountersCmd )
