#!/usr/bin/env python
# Copyright (c) 2009, 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# Implements no CLI commands.  Contains code to reset disabled*Intf state to
# default values when interfaces are deleted.
#-------------------------------------------------------------------------------
import Tac
import IntfCli
import ConfigMount
import Tracing

__defaultTraceHandle__ = Tracing.Handle( 'SflowCli' )
t8 = Tracing.trace8

sflowConfig = None

class SflowIntfJanitor( IntfCli.IntfDependentBase ):
   """When someone 'no sflow enable''s an interface, this class is created as a
   handle in case the interface is removed.  At which point we remove the
   associated interface from the Sflow disabled*Intf collection.  This way,
   even when Sflow is not running the disabled*Intf will be somewhat accurate.
   Primarily concerned with LAG's here, since only they can be removed from the
   Cli"""
   def setDefault( self ):
      self.removeFromDisabledIntf()
      self.removeFromEnabledIntf()

   def removeFromDisabledIntf( self ):
      del sflowConfig.disabledIngressIntf[ self.intf_.name ]
      del sflowConfig.disabledEgressIntf[ self.intf_.name ]

   def removeFromEnabledIntf( self ):
      del sflowConfig.enabledIngressIntf[ self.intf_.name ]
      del sflowConfig.enabledEgressIntf[ self.intf_.name ]

def Plugin( entityManager ):
   global sflowConfig
   sflowConfig = ConfigMount.mount( entityManager, "sflow/config",
                                    "Sflow::Config", "w" )
   IntfCli.Intf.registerDependentClass( SflowIntfJanitor, priority=10 )
