#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliPlugin.TechSupportCli
import SfeCliLib

# Register Sfe Cli commands with 'show tech-support'
def _SfeShowTechCmds():
   # Ensure that Sfe is running before issuing commands for it
   assert SfeCliLib.entityManager
   if SfeCliLib.isSfeAgentRunning( SfeCliLib.entityManager.sysname(), 'Sfe' ):
      return [ 'show platform sfe counters',
               'show platform sfe l3 next-hops',
               'show platform sfe l3 next-hops diff',
               'show platform sfe l3 unicast summary',
               'show platform sfe ip route',
               'show platform sfe mirroring',
               'show cpu counters queue | nz',
               'show interfaces counters queue detail | nz',
               'show interface counters discard | nz',
               'show platform sfe nat counters',
               'show platform sfe qos',
               'show agent Sfe logs',
               'bash /usr/share/bess/bessctl/bessctl show status',
               'bash /usr/share/bess/bessctl/bessctl show port',
               'bash /usr/share/bess/bessctl/bessctl show busy',
               'bash /usr/share/bess/bessctl/bessctl show system packets',
               'bash /usr/share/bess/bessctl/bessctl show pipeline',
               'bash /usr/share/bess/bessctl/bessctl show module',
               'bash /usr/share/bess/bessctl/bessctl show tc',
               'bash /usr/share/bess/bessctl/bessctl show offload-info-stats',
               'bash /usr/share/bess/bessctl/bessctl show ipsec-crypto-stats',
               'bash /usr/share/bess/bessctl/bessctl show ipsec-sa-state',
               'bash /usr/share/bess/bessctl/bessctl show ipsec-sa-stats',
               'bash /usr/share/bess/bessctl/bessctl show ipsec-module-stats',
               'bash /usr/share/bess/bessctl/bessctl show dps rules',
               'bash /usr/share/bess/bessctl/bessctl show dps bestpath',
               'bash lspci',
               'bash ifconfig -a',
               'bash lscpu',
               # multiline string below
               'bash for i in `ip link | egrep -o \"et[0-9]+:\" | tr \'\n\' \' \' |'
               'sed s/://g`; do echo $i; ethtool -S $i; done',
               'bash sudo /usr/share/dpdk/tools/dpdk-procinfo -- -m',
               'bash sudo /usr/share/dpdk/tools/dpdk-procinfo -- --xstats',
               'bash sudo /usr/share/dpdk/tools/dpdk-procinfo -- --show-mempool',
               'bash sudo /usr/share/dpdk/tools/dpdk-procinfo -- --show-ring',
               # doesn't work for IGB driver
               'bash if ! sudo /usr/share/dpdk/tools/dpdk-devbind.py -s |'
               'grep -q \"ixgbe\" ; then '
               'sudo /usr/share/dpdk/tools/dpdk-procinfo -- --show-port; fi',
   ]
   return []

CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback(
   '2018-09-17 23:00:00', _SfeShowTechCmds )
CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback(
   '2018-09-17 23:00:00', _SfeShowTechCmds, extended='sfe' )
