# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import Tracing
import IntfQueueCounterLib
import IntfCli
import CliPlugin.QueueCountersCli as QueueCountersCli
from CliPlugin.QueueCountersModel import QueueCounters, EgressQueueCounters
from CliPlugin.QueueCountersModel import EgressQueueDestinationTypeCounters
from CliPlugin.QueueCountersModel import EgressQueueTrafficClassCounters
from CliPlugin.QueueCountersModel import EgressQueueDropPrecedenceCounters, Counters
import Smash
import SfeCliLib
from TypeFuture import TacLazyType
import ShowCommand
import CliCommand

__defaultTraceHandle__ = Tracing.Handle( 'SfeQueueCounters' )

#-------------------------------------------------------------------------------
# The platform-specific "show interfaces [<name>] counters queue" command.
#-------------------------------------------------------------------------------
def showIntfQueueDropCounters( mode, intf=None, mod=None ):
   counterAccessor = IntfQueueCounterLib.getCounterAccessor()
   queueCountersModel = QueueCounters()
   queueCountersModel.egressQueueCounters = EgressQueueCounters()
   intfs = IntfCli.counterSupportedIntfs( mode, intf, mod )
   if intfs:
      # filter out non-'Ethernet' interfaces
      intfs = [ i for i in intfs if i.name.startswith( 'Ethernet' ) ]
   if not intfs:
      return queueCountersModel

   formatStr = '%-10s %13s'
   header = formatStr % ( 'Port', 'OutDropPkts' )
   print header
   print '-' * len( header )

   for f in intfs:
      counter = counterAccessor.counterDiff( f.name, 'lastClear' )
      outDrops = 0
      numUnicastQueues = counterAccessor.numUnicastQueues( f.name )
      for q in xrange( numUnicastQueues ):
         intfStat = counter.intfQueueStat[ q ]
         outDrops += intfStat.pktsDropped
      print formatStr % ( f.shortname, outDrops )

   return queueCountersModel

#-------------------------------------------------------------------------------
# The platform-specific "show interfaces [<name>] counters queue detail" command.
#-------------------------------------------------------------------------------
def showIntfQueueCounters( mode, intf=None, mod=None, detail=None ):
   counterAccessor = IntfQueueCounterLib.getCounterAccessor()
   queueCountersModel = QueueCounters( _renderType="Sfe" )
   queueCountersModel.egressQueueCounters = EgressQueueCounters()
   intfs = IntfCli.counterSupportedIntfs( mode, intf, mod )
   interfaces = queueCountersModel.egressQueueCounters.interfaces
   if intfs:
      # filter out non-'Ethernet' interfaces
      intfs = [ i for i in intfs if i.name.startswith( 'Ethernet' ) ]
   if not intfs:
      return queueCountersModel

   for f in intfs:
      intfId = f.name
      interfaces[ intfId ] = EgressQueueDestinationTypeCounters()
      interfaces[ intfId ].ucastQueues = EgressQueueTrafficClassCounters()
      interfaces[ intfId ].mcastQueues = EgressQueueTrafficClassCounters()
      counter = counterAccessor.counterDiff( intfId, 'lastClear' )
      numUnicastQueues = counterAccessor.numUnicastQueues( intfId )
      for q in xrange( numUnicastQueues ):
         intfStat = counter.intfQueueStat[ q ]
         tc = interfaces[ intfId ].ucastQueues.trafficClasses
         tcId = "Q%u" % q
         tc[ tcId ] = EgressQueueDropPrecedenceCounters()
         tc[ tcId ].dropPrecedences[ "DP0" ] = Counters()
         ctrs = tc[ tcId ].dropPrecedences[ "DP0" ]
         ctrs.enqueuedPackets = intfStat.pkts
         ctrs.enqueuedBytes = intfStat.bytes
         ctrs.droppedPackets = intfStat.pktsDropped
         ctrs.droppedBytes = intfStat.bytesDropped

   return queueCountersModel

def showInterfacesQueueCounters( mode, intf=None, mod=None, detail=None ):
   if detail:
      return showIntfQueueCounters( mode, intf=intf, mod=mod )
   else:
      return showIntfQueueDropCounters( mode, intf=intf, mod=mod )

QueueCountersCli.showInterfacesQueueCountersHook.addExtension(
      ( showInterfacesQueueCounters, SfeCliLib.notHwPlatform, True, False ) )

#-------------------------------------------------------------------------------
# The platform-specific "show cpu counters queue" command.
#-------------------------------------------------------------------------------
sfeQosConstants = TacLazyType( 'Sfe::SfeQosConstants' )

def showCpuCountersQueue( mode, args ):
   # mounte counters
   queueCounterMountInfo = Smash.mountInfo( 'reader' )
   allCpuQueueCounters = IntfQueueCounterLib.smashEntityManager.doMount(
         "counters/cpuQueue/sfe/current",
         "Interface::CpuCounter::AllCpuQueueCounters", queueCounterMountInfo )
   allCpuClearQueueCounters = IntfQueueCounterLib.smashEntityManager.doMount(
         "counters/cpuQueue/sfe/lastClear",
         "Interface::CpuCounter::AllCpuQueueCounters", queueCounterMountInfo )

   formatStr = "%s%20s%20s%20s"
   header = formatStr % ( "TxQ", "Pkts", "Bytes", "DropPkts" )
   print header
   print '-' * len( header )

   counter = allCpuQueueCounters.egressQueueCounter[ "Cpu" ]
   clearCounter = allCpuClearQueueCounters.egressQueueCounter[ "Cpu" ]
   if not counter or not clearCounter:
      return

   for q in xrange( sfeQosConstants.cpuNumOfTxQueue ):
      cpuStat = counter.cpuQueueStat[ q ]
      clearCpuStat = clearCounter.cpuQueueStat[ q ]
      if not cpuStat or not clearCpuStat:
         continue

      txQId = 'Q%u' % q
      statPkts = str( cpuStat.pkts - clearCpuStat.pkts )
      statBytes = str( cpuStat.bytes - clearCpuStat.bytes )
      statPktsDropped = ( cpuStat.pktsDropped - clearCpuStat.pktsDropped )
      print formatStr % ( txQId, statPkts, statBytes, statPktsDropped )

class CpuCountersQueueCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show cpu counters queue'
   data = {
      'cpu' : CliCommand.guardedKeyword( 'cpu', helpdesc='CPU port',
                                         guard=SfeCliLib.notHwPlatform ),
      'counters' : 'CPU counters',
      'queue' : 'Queue counters',
   }

   handler = showCpuCountersQueue

BasicCli.addShowCommandClass( CpuCountersQueueCmd )
