#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Int, Bool, List, Model
from ArnetModel import Ip4Address
from TableOutput import Format, createTable

class SfeNatShowCountersModel( Model ):
   """ Represents natShowCounters """
   stSrcAddAttempt = Int( help="Number of static source add attempts",
                          default=0 )
   stSrcAddSuccess = Int( help="Number of static source add successes",
                          default=0 )
   stSrcUpdAttempt = Int( help="Number of static source update attempts",
                          default=0 )
   stSrcUpdSuccess = Int( help="Number of static source update successes",
                          default=0 )
   stSrcDelAttempt = Int( help="Number of static source delete attempts",
                          default=0 )
   stSrcDelSuccess = Int( help="Number of static source delete successes",
                          default=0 )
   stSrcData = Int( help="Number of static source records", default=0 )
   stSrcAclData = Int( help="Number of static source ACL records", default=0 )
   stSrcModuleFlows = Int( help="Number of static source module flows",
                           default=0 )

   stDstAddAttempt = Int( help="Number of static destination add attempts",
                          default=0 )
   stDstAddSuccess = Int( help="Number of static destination add successes",
                          default=0 )
   stDstUpdAttempt = Int( help="Number of static destination update attempts",
                          default=0 )
   stDstUpdSuccess = Int( help="Number of static destination update successes",
                          default=0 )
   stDstDelAttempt = Int( help="Number of static destination delete attempts",
                          default=0 )
   stDstDelSuccess = Int( help="Number of static destination delete successes",
                          default=0 )
   stDstData = Int( help="Number of static destination NAT records",
                    default=0 )
   stDstAclData = Int( help="Number of static destination ACL records",
                       default=0 )
   stDstModuleFlows = Int( help="Number of static destination module flows",
                           default=0 )

   dySrcAddAttempt = Int( help="Number of dynamic source add attempts",
                          default=0 )
   dySrcAddSuccess = Int( help="Number of dynamic source add successes",
                          default=0 )
   dySrcUpdAttempt = Int( help="Number of dynamic source update attempts",
                          default=0 )
   dySrcUpdSuccess = Int( help="Number of dynamic source update successes",
                          default=0 )
   dySrcDelAttempt = Int( help="Number of dynamic source delete attempts",
                          default=0 )
   dySrcDelSuccess = Int( help="Number of dynamic source delete successes",
                          default=0 )
   dySrcTrapAddAttempt = Int( help="Number of dynamic source trap add attempts",
                              default=0 )
   dySrcTrapAddSuccess = Int( help="Number of dynamic source trap add successes",
                              default=0 )
   dySrcTrapDelAttempt = Int( help="Number of dynamic source trap delete attempts",
                              default=0 )
   dySrcTrapDelSuccess = Int( help="Number of dynamic source trap delete successes",
                              default=0 )
   dySrcData = Int( help="Number of dynamic source records", default=0 )
   dySrcTrap = Int( help="Number of dynamic source trap records",
                    default=0 )
   dySrcModuleFlows = Int( help="Number of dynamic source module flows",
                           default=0 )

   dyDstAddAttempt = Int( help="Number of dynamic destination add attempts",
                          default=0 )
   dyDstAddSuccess = Int( help="Number of dynamic destination add successes",
                          default=0 )
   dyDstUpdAttempt = Int( help="Number of dynamic destination update attempts",
                          default=0 )
   dyDstUpdSuccess = Int( help="Number of dynamic destination update successes",
                          default=0 )
   dyDstDelAttempt = Int( help="Number of dynamic destination delete attempts",
                          default=0 )
   dyDstDelSuccess = Int( help="Number of dynamic destination delete successes",
                          default=0 )
   dyDstTrapAddAttempt = Int( help="Number of dynamic destination trap add attempts",
                              default=0 )
   dyDstTrapAddSuccess = Int(
      help="Number of dynamic destination trap add successes",
      default=0 )
   dyDstTrapDelAttempt = Int(
      help="Number of dynamic destination trap delete attempts",
      default=0 )
   dyDstTrapDelSuccess = Int(
      help="Number of dynamic destination trap delete successes",
      default=0 )
   dyDstData = Int( help="Number of dynamic destination records",
                    default=0 )
   dyDstTrap = Int( help="Number of dynamic destination trap records",
                    default=0 )
   dyDstModuleFlows = Int( help="Number of dynamic destination module flows",
                           default=0 )

   modProcessingError = Int(
      help="Number of errors in processing grpc messages by module",
      default=0 )
   modFlowProcessingFail = Int(
      help="Number of failure in dynamic flow processing by module",
      default=0 )

   def render( self ):
      print "Static source add attempt: %u, success: %u" % \
         ( self.stSrcAddAttempt, self.stSrcAddSuccess )
      print "Static source update attempt: %u, success: %u" % \
         ( self.stSrcUpdAttempt, self.stSrcUpdSuccess )
      print "Static source delete attempt: %u, success: %u" % \
         ( self.stSrcDelAttempt, self.stSrcDelSuccess )
      print "Static source data: %u" % \
         ( self.stSrcData )
      print "Static source acl data: %u" % \
         ( self.stSrcAclData )

      print "Static destination add attempt: %u, success: %u" % \
         ( self.stDstAddAttempt, self.stDstAddSuccess )
      print "Static destination update attempt: %u, success: %u" % \
         ( self.stDstUpdAttempt, self.stDstUpdSuccess )
      print "Static destination delete attempt: %u, success: %u" % \
         ( self.stDstDelAttempt, self.stDstDelSuccess )
      print "Static destination data: %u" % \
         ( self.stDstData )
      print "Static destination acl data: %u" % \
         ( self.stDstAclData )

      print "Dynamic source add attempt: %u, success: %u" % \
         ( self.dySrcAddAttempt, self.dySrcAddSuccess )
      print "Dynamic source update attempt: %u, success: %u" % \
         ( self.dySrcUpdAttempt, self.dySrcUpdSuccess )
      print "Dynamic source delete attempt: %u, success: %u" % \
         ( self.dySrcDelAttempt, self.dySrcDelSuccess )
      print "Dynamic source trap add attempt: %u, success: %u" % \
         ( self.dySrcTrapAddAttempt, self.dySrcTrapAddSuccess )
      print "Dynamic source trap delete attempt: %u, success: %u" % \
         ( self.dySrcTrapDelAttempt, self.dySrcTrapDelSuccess )
      print "Dynamic source data: %u" % \
         ( self.dySrcData )
      print "Dynamic source trap: %u" % \
         ( self.dySrcTrap )

      print "Dynamic destination add attempt: %u, success: %u" % \
         ( self.dyDstAddAttempt, self.dyDstAddSuccess )
      print "Dynamic destination update attempt: %u, success: %u" % \
         ( self.dyDstUpdAttempt, self.dyDstUpdSuccess )
      print "Dynamic destination delete attempt: %u, success: %u" % \
         ( self.dyDstDelAttempt, self.dyDstDelSuccess )
      print "Dynamic destination trap add attempt: %u, success: %u" % \
         ( self.dyDstTrapAddAttempt, self.dyDstTrapAddSuccess )
      print "Dynamic destination trap delete attempt: %u, success: %u" % \
         ( self.dyDstTrapDelAttempt, self.dyDstTrapDelSuccess )
      print "Dynamic destination data: %u" % \
         ( self.dyDstData )
      print "Dynamic destination trap: %u" % \
         ( self.dyDstTrap )

      print "Module message processing errors: %u" % \
         ( self.modProcessingError )
      print "Module flow processing failed: %u" % \
         ( self.modFlowProcessingFail )

      print "Module total static source flows: %u" % \
         ( self.stSrcModuleFlows )
      print "Module total static destination flows: %u" % \
         ( self.stDstModuleFlows )

      print "Module total dynamic source flows: %u" % \
         ( self.dySrcModuleFlows )
      print "Module total dynamic destination flows: %u" % \
         ( self.dyDstModuleFlows )


class SfeNatShowPoolsModel( Model ):
   """NAT pool configured in BESS"""

   class PoolRange( Model ):
      poolId = Int( help="NAT pool ID" )
      entryId = Int( help="NAT pool range hardware entry ID" )
      nextEntryId = Int( help="Next NAT pool range hardware entry ID" )
      addrStart = Ip4Address( "NAT pool range start IP address" )
      portStart = Int( "NAT pool range start L4 port" )
      addrEnd = Ip4Address( "NAT pool range start IP address" )
      portEnd = Int( "NAT pool range start L4 port" )
      addrLast = Ip4Address( "Last IP address allocated in the NAT pool range" )
      portLast = Int( "Last L4 port allocated in the NAT pool range" )

   detail = Bool( help="Verbose output" )
   poolRanges = List( valueType=PoolRange,
                      help="NAT pool ranges configured in the platform" )

   def render( self ):
      fmtL = Format( justify="left" )
      fmtR = Format( justify="right" )
      if self.detail:
         table = createTable( ( "Pool ID", "Entry ID", "Next", "Start IP", "End IP",
                                "Start L4", "End L4", "Last IP", "Last L4" ),
                              tableWidth=120 )
         table.formatColumns( fmtR, fmtR, fmtR, fmtL, fmtL, fmtR, fmtR, fmtL, fmtR )

         for r in self.poolRanges:
            table.newRow( r.poolId, r.entryId, r.nextEntryId, r.addrStart, r.addrEnd,
                          r.portStart, r.portEnd, r.addrLast, r.portLast )
      else:
         table = createTable( ( "Pool ID", "Entry ID", "Next",
                                "Start IP", "End IP", "Start L4", "End L4" ),
                              tableWidth=120 )
         table.formatColumns( fmtR, fmtR, fmtR, fmtL, fmtL, fmtR, fmtR )

         for r in self.poolRanges:
            table.newRow( r.poolId, r.entryId, r.nextEntryId, r.addrStart, r.addrEnd,
                          r.portStart, r.portEnd )

      output = table.output()
      print output
