#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import AgentCommandRequest
import SfeAgent
import cStringIO
from SfeNatShowCliModel import SfeNatShowCountersModel
from SfeNatShowCliModel import SfeNatShowPoolsModel
import ShowCommand
from SfeCliLib import nodeSfe
from CliToken.Platform import platformMatcherForShow

#---------------------------------------------------------------------------------
# show platform sfe nat counters
#---------------------------------------------------------------------------------
def doShowSfeNatCounters( mode, args ):
   buff = cStringIO.StringIO()
   AgentCommandRequest.runSocketCommand( mode.entityManager, SfeAgent.name(),
                                         "sfe", "NATcnt", stringBuff=buff )
   output = buff.getvalue()
   try:
      # pylint: disable-msg=W0123
      natCounters = eval( output )
   except SyntaxError:
      mode.addError( output )
      return SfeNatShowCountersModel()

   model = SfeNatShowCountersModel()
   model.setAttrsFromDict( natCounters )
   return model

class PlatformSfeNatCountersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show platform sfe nat counters'
   data = {
      'platform' : platformMatcherForShow,
      'sfe' : nodeSfe,
      'nat' : 'Show nat info',
      'counters' : 'Show nat counters',
   }

   handler = doShowSfeNatCounters
   cliModel = SfeNatShowCountersModel
   privileged = True

BasicCli.addShowCommandClass( PlatformSfeNatCountersCmd )

#---------------------------------------------------------------------------------
# show platform sfe nat pool [detail]
#---------------------------------------------------------------------------------
def doShowSfeNatPool( mode, args ):
   buff = cStringIO.StringIO()
   detail = 'detail' in args
   cmd = 'NATpoolDetail' if detail else 'NATpool'
   AgentCommandRequest.runSocketCommand( mode.entityManager, SfeAgent.name(),
                                         "sfe", cmd, stringBuff=buff,
                                         timeout=50, keepalive=True )
   output = buff.getvalue()
   try:
      # pylint: disable-msg=W0123
      natPools = eval( output )
   except SyntaxError:
      mode.addError( output )
      return SfeNatShowPoolsModel()

   pools = SfeNatShowPoolsModel()
   pools.detail = detail
   for poolRange in natPools:
      rangeModel = SfeNatShowPoolsModel.PoolRange()
      rangeModel.setAttrsFromDict( poolRange )
      pools.poolRanges.append( rangeModel )
   return pools

class PlatformSfeNatPoolCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show platform sfe nat pool [detail]'
   data = {
      'platform' : platformMatcherForShow,
      'sfe' : nodeSfe,
      'nat' : 'Show nat info',
      'pool' : 'Show nat pool',
      'detail' : 'Verbose output',
   }

   handler = doShowSfeNatPool
   cliModel = SfeNatShowPoolsModel
   privileged = True

BasicCli.addShowCommandClass( PlatformSfeNatPoolCmd )
