#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
#import re
import Tac
import CliCommand
import CliMatcher
import CliParser
import LazyMount
import AgentDirectory
import SmashLazyMount
import Cell

import os

entityManager = None
portVifStatus = None
sfePhyStatusDir = None
launcherConfig = None
v4RouteCacheHitbitStatus = None
phyConfigDir = None

def sfe():
   # pylint: disable=consider-using-ternary
   return ( ( launcherConfig and launcherConfig.has_key( 'Sfe' ) ) or
            os.getenv( "SIMULATION_SFE" ) )

def sfeGuard( mode, token ):
   if sfe():
      return None
   else:
      return CliParser.guardNotThisPlatform

def sfeEosGuard( mode, token ):
   if sfe() or AgentDirectory.agent( mode.sysname, 'BessMgr' ):
      return None
   else:
      return CliParser.guardNotThisPlatform

def notHwPlatform( mode, token ):
   pcdPath = 'hardware/cell/%s/phy/sfe/config' % Cell.cellId()
   pcd = phyConfigDir
   if pcd is None:
      pcd = mode.sysdbRoot.entity[ pcdPath ]

   # If it is hw platform return not-supported right away
   if pcd.hwPlatform:
      return CliParser.guardNotThisPlatform

   # If it is not hwPlatform, do SFE specific check
   return sfeGuard( mode, token )

matcherSfe = CliMatcher.KeywordMatcher( 'sfe',
                                        'Sfe (Software Forwarding Engine)' )
nodeSfe = CliCommand.Node( matcher=matcherSfe, guard=sfeGuard )
nodeSfeEos = CliCommand.Node( matcher=matcherSfe, guard=sfeEosGuard )

def isSfeRunning( sysname ):
   if AgentDirectory.agent( sysname, 'SfeCentral' ):
      # The SfeCentral agent will launch the SFE slice agents so it can gate
      # if we're a SFE system
      return True
   else:
      return False

def isSfeAgentRunning( sysname, agentName ):
   if not agentName.startswith( "Sfe" ):
      return False
   if AgentDirectory.agent( sysname, agentName ):
      return True
   else:
      return False

def Plugin( em ):
   global entityManager
   entityManager = em
   global portVifStatus
   global sfePhyStatusDir
   global launcherConfig
   global v4RouteCacheHitbitStatus
   global phyConfigDir

   portVifStatus = LazyMount.mount( em, 'hardware/sfe/vif/status/port',
                                    'SfeVif::PortVifStatus', 'r' )
   # take sfe phystatus directly from the hardware tree
   sfePhyStatusDir = LazyMount.mount( em,
         'hardware/phy/status/sfe80Phy/slice/FixedSystem/SfeSlice',
         'SfeSlice::PhySfe80StatusDir', 'r' )

   launcherConfig = LazyMount.mount( em, 'hardware/sfe/launcherConfig',
                                    'Tac::Dir', 'ri' )

   v4RouteCacheHitbitStatus = SmashLazyMount.mount( entityManager,
         'sfe/routecache/status/ipv4',
         'RouteCache::Ipv4HitBitStatus',
         SmashLazyMount.mountInfo( 'reader' ) )

   phyConfigDir = LazyMount.mount( em,
         'hardware/cell/%s/phy/sfe/config' % Cell.cellId(),
         'Hardware::Phy::SfePhyConfigDir', 'r' )
