# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import CliCommand
import CliMatcher
import CliPlugin
import ShowCommand

matcherPlatform = CliMatcher.KeywordMatcher(
   'platform',
   helpdesc='Platform-specific information' )
matcherScd = CliMatcher.KeywordMatcher(
   'scd',
   helpdesc='System control device information' )
matcherSatellite = CliMatcher.KeywordMatcher(
   'satellite',
   helpdesc='SCD satellite information' )
matcherScdName = CliMatcher.DynamicNameMatcher(
   namesFn=CliPlugin.Scd.satelliteScdNameFn,
   helpdesc='Scd name' )
matcherDebug = CliMatcher.KeywordMatcher( 'debug', helpdesc='debug information' )

#--------------------------------------------------------------------------------
# show platform scd satellite debug
#--------------------------------------------------------------------------------
class SatelliteErrorsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show platform scd satellite [ SCD-NAME ] debug'
   data = {
      'platform': matcherPlatform,
      'scd': CliCommand.Node( matcher=matcherScd,
                              guard=CliPlugin.Scd.satelliteScdGuard ),
      'satellite': matcherSatellite,
      'SCD-NAME': matcherScdName,
      'debug': matcherDebug,
   }
   handler = CliPlugin.Scd.doShowSatelliteDebug
   cliModel = CliPlugin.Scd.SatelliteDebug
   privileged = True

BasicCli.addShowCommandClass( SatelliteErrorsCmd )
