# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
from CliPlugin.RsvpLerShowCli import RsvpLerTunnelFilterArg
from CliToken.Refresh import refreshMatcherForExec
import ConfigMount
import Tac
from TypeFuture import TacLazyType
import Toggles.RsvpToggleLib

RsvpLerCliConfig = TacLazyType( 'Rsvp::RsvpLerCliConfig' )
RsvpLerTunnelSpecId = TacLazyType( 'Rsvp::RsvpLerTunnelSpecId' )
tunnelSourceCli = TacLazyType( 'Rsvp::RsvpLerTunnelSource' ).tunnelSourceCli

config = None

def doOptimizeRsvpTunnel( tunnelSpec ):
   tunnelSpec.forceOptimize += 1

def optimizeRsvpTunnels( mode, args ):
   filters = args.get( 'FILTERS' )
   tunnelSpecColl = config.tunnelSpecCollTable.tunnelSpecColl.get( tunnelSourceCli )
   if not tunnelSpecColl:
      return
   if 'all' in args:
      # Optimize all the tunnels in tunnelSpecColl
      for tunnelSpec in tunnelSpecColl.tunnelSpec.itervalues():
         doOptimizeRsvpTunnel( tunnelSpec )
   elif filters:
      # Optimize only those tunnels that match the passed filter.
      for filterType, arg in filters:
         if filterType == 'tunnelFilter':
            filterAttr, filterValue = arg
            if filterAttr in [ 'tunnelName' ]:
               tunnelName = filterValue
               tunnelSpecId = RsvpLerTunnelSpecId( tunnelName, tunnelSourceCli )
               tunnelSpec = tunnelSpecColl.tunnelSpec.get( tunnelSpecId )
               if tunnelSpec:
                  doOptimizeRsvpTunnel( tunnelSpec )

#-----------------------------------------------------------------------------------
# 'refresh rsvp tunnel optimization ( all | FILTERS )'
# in privileged EXEC mode
#-----------------------------------------------------------------------------------
class RsvpOptimizationExecCmd( CliCommand.CliCommandClass ):
   syntax = 'refresh rsvp tunnel optimization ( all | FILTERS )'
   data = {
      'refresh': refreshMatcherForExec,
      'rsvp': 'Refresh RSVP information',
      'tunnel': 'Refresh RSVP tunnels',
      'optimization': 'Refresh RSVP tunnels by optimizing them',
      'all': 'Optimize all RSVP tunnels',
      'FILTERS': RsvpLerTunnelFilterArg,
   }
   handler = optimizeRsvpTunnels

if Toggles.RsvpToggleLib.toggleRsvpLerReoptimizationEnabled():
   BasicCliModes.EnableMode.addCommandClass( RsvpOptimizationExecCmd )

#--------------------------------------------------------------------------------
# Plugin
#--------------------------------------------------------------------------------
def Plugin( entityManager ):
   global config
   config = ConfigMount.mount( entityManager, RsvpLerCliConfig.mountPath,
                               'Rsvp::RsvpLerCliConfig', 'w' )
