# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pkgdeps: rpmwith %{_libdir}/libRsvp.so*

from __future__ import absolute_import, division, print_function

import LazyMount
import BasicCliModes
import CliCommand
import CliToken.Clear
import CliToken.Rsvp
import CliPlugin.AclCli as AclCli
import CliPlugin.MplsCli as MplsCli
import Tac

aclStatus = None
aclCheckpoint = None

#--------------------------------------------------------------------------------
# clear mpls rsvp counters ( ip | ipv6 ) access-list
#--------------------------------------------------------------------------------
class ClearMplsRsvpCountersIpAccessListCmd( CliCommand.CliCommandClass ):
   syntax = 'clear mpls rsvp counters ( ip | ipv6 ) access-list'
   data = {
      'clear': CliToken.Clear.clearKwNode,
      'mpls': MplsCli.mplsMatcherForClear,
      'rsvp': CliToken.Rsvp.rsvpMatcherForClear,
      'counters': AclCli.countersKwMatcher,
      'ip': AclCli.ipKwForClearServiceAclMatcher,
      'ipv6': AclCli.ipv6KwMatcherForServiceAcl,
      'access-list': AclCli.accessListKwMatcherForServiceAcl,
   }

   @staticmethod
   def handler( mode, args ):
      aclType = 'ipv6' if 'ipv6' in args else 'ip'
      AclCli.clearServiceAclCounters( mode, aclStatus, aclCheckpoint, aclType )

BasicCliModes.EnableMode.addCommandClass( ClearMplsRsvpCountersIpAccessListCmd )

def Plugin( entityManager ):
   global aclStatus
   aclStatus = LazyMount.mount( entityManager, "acl/status/all", "Acl::Status", "r" )

   global aclCheckpoint
   aclCheckpoint = LazyMount.mount( entityManager, "acl/checkpoint",
                                    "Acl::CheckpointStatus", "w" )
