#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import ConfigMount
from CliPlugin.SnmpCli import snmpServerKwMatcher

ribSnmpConfig = None

matcherRoutingMibs = CliMatcher.KeywordMatcher( 'routing-mibs',
      helpdesc='Enable routing-related MIBS' )

#--------------------------------------------------------------------------------
# [ no | default ] snmp-server routing-mibs
#--------------------------------------------------------------------------------
class SnmpServerRoutingMibsCmd( CliCommand.CliCommandClass ):
   syntax = 'snmp-server routing-mibs'
   noOrDefaultSyntax = syntax
   data = {
      'snmp-server': snmpServerKwMatcher,
      'routing-mibs': matcherRoutingMibs,
   }
   hidden = True

   @staticmethod
   def handler( mode, args ):
      ribSnmpConfig.enabled = True

   @staticmethod
   def noHandler( mode, args ):
      ribSnmpConfig.enabled = False

   @staticmethod
   def defaultHandler( mode, args ):
      ribSnmpConfig.enabled = ribSnmpConfig.routingMibsDefault

BasicCliModes.GlobalConfigMode.addCommandClass( SnmpServerRoutingMibsCmd )

#--------------------------------------------------------------------------------
# snmp-server routing-mibs timers PING RESTART
#--------------------------------------------------------------------------------
class SnmpServerRoutingMibsTimersPingRestartCmd( CliCommand.CliCommandClass ):
   _minTime = 2
   _maxTime = 600
   syntax = 'snmp-server routing-mibs timers PING RESTART'
   noOrDefaultSyntax = 'snmp-server routing-mibs timers ...'
   data = {
      'snmp-server': snmpServerKwMatcher,
      'routing-mibs': matcherRoutingMibs,
      'timers': 'Agentx Timers',
      'PING': CliMatcher.IntegerMatcher( _minTime, _maxTime,
                                         helpdesc='Ping interval' ),
      'RESTART': CliMatcher.IntegerMatcher( _minTime, _maxTime,
                                            helpdesc='Restart interval' ),
   }
   hidden = True

   @staticmethod
   def handler( mode, args ):
      ribSnmpConfig.pingTime = args[ 'PING' ]
      ribSnmpConfig.restartTime = args[ 'RESTART' ]

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      ribSnmpConfig.pingTime = ribSnmpConfig.pingTimeDefault
      ribSnmpConfig.restartTime = ribSnmpConfig.restartTimeDefault

BasicCliModes.GlobalConfigMode.addCommandClass(
      SnmpServerRoutingMibsTimersPingRestartCmd )

#-------------------------------------------------------------------------------
def Plugin( entityManager ):
   global ribSnmpConfig
   ribSnmpConfig = ConfigMount.mount(
      entityManager, "routing/snmpConfig", "Routing::SnmpConfig", "w" )
