# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from BasicCli import addShowCommandClass
from ShowCommand import ShowCliCommandClass

from CliPlugin.IpAddrMatcher import ipPrefixMatcher
from CliPlugin.Ip6AddrMatcher import ip6PrefixMatcher
import CliPlugin.RoutingBgpShowCli
from CliPlugin.RoutingBgpShowCli import (
      allVrfExprFactory,
      autoAggrVrfModel,
   )
from CliToken.RoutingBgpShowCliTokens import (
      autoAggr,
      bgpAfterShow,
      detail,
      ipv4AfterShowBgp,
      ipv6AfterShowBgp,
   )

# This file provides the CLI parser handling for BGP show commands that are
# specific to the unicast SAFI

#-------------------------------------------------------------------------------
# HIDDEN
# "show bgp auto-aggregation ipv[4|6] [prefix] [detail] [vrf <vrfName>]"
#-------------------------------------------------------------------------------
class ShowBgpAutoAggrIpv4( ShowCliCommandClass ):
   syntax = """show bgp auto-aggregation ipv4 [ PREFIX ] [detail] [ VRF ]"""
   data = {
         "bgp": bgpAfterShow,
         "auto-aggregation": autoAggr,
         "ipv4": ipv4AfterShowBgp,
         "PREFIX": ipPrefixMatcher,
         "detail": detail,
         "VRF": allVrfExprFactory,
      }
   cliModel = autoAggrVrfModel

   @staticmethod
   def handler( mode, args ):
      return CliPlugin.RoutingBgpShowCli.doShowAutoAggrIpv4(
            mode,
            prefix=args.get( "PREFIX" ),
            detail=args.get( "detail" ),
            vrfName=args.get( "VRF" ) )

addShowCommandClass( ShowBgpAutoAggrIpv4 )

class ShowBgpAutoAggrIpv6( ShowCliCommandClass ):
   syntax = """show bgp auto-aggregation ipv6 [ PREFIX ] [detail] [ VRF ]"""
   data = {
         "bgp": bgpAfterShow,
         "auto-aggregation": autoAggr,
         "ipv6": ipv6AfterShowBgp,
         "PREFIX": ip6PrefixMatcher,
         "detail": detail,
         "VRF": allVrfExprFactory,
      }
   cliModel = autoAggrVrfModel

   @staticmethod
   def handler( mode, args ):
      return CliPlugin.RoutingBgpShowCli.doShowAutoAggrIpv6(
            mode,
            prefix=args.get( "PREFIX" ),
            detail=args.get( "detail" ),
            vrfName=args.get( "VRF" ) )

addShowCommandClass( ShowBgpAutoAggrIpv6 )
