#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
from CliPlugin import TechSupportCli
from CliPlugin.RoutingCommon import (
   GATED_PROTO_SH_TECH_TS,
   GATED_PROTO_FORK_SH_TECH_TS
)

#-------------------------------------------------------------------------------
# BGP commands in "show tech-support"
#-------------------------------------------------------------------------------

def _showTechSupportCmds():
   cmds = [ "show bgp convergence",
            "show bgp statistics",
            "show bgp rcf" ]
   return cmds

def _showTechSupportCmdsFork():
   # List of 'show ip bgp ...' commands that fork ribd to produce their output
   cmds = [ "show ip bgp vrf all",
            "show ipv6 bgp vrf all",
            "show ip bgp summary vrf all",
            "show ipv6 bgp summary vrf all",
            "show ip bgp neighbor vrf all",
            "show ipv6 bgp peers vrf all",
            "show bgp sr-te summary vrf all",
            # Use "detail" since that's the only version that prints the tunnel encap
            # attr info
            "show bgp sr-te detail vrf all"
   ]
   return cmds

TechSupportCli.registerShowTechSupportCmdCallback(
   GATED_PROTO_SH_TECH_TS, _showTechSupportCmds )

TechSupportCli.registerShowTechSupportCmdCallback(
   GATED_PROTO_FORK_SH_TECH_TS, _showTechSupportCmdsFork )

TechSupportCli.registerShowTechSupportCmdCallback(
      '2020-05-20 23:59:59', lambda: [],
      summaryCmdCallback=lambda: [
            "show bgp statistics",
            "show ip bgp summary vrf all",
            "show ipv6 bgp summary vrf all",
            "show bgp sr-te summary vrf all",
         ] )
