# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from BasicCli import addShowCommandClass
from ShowCommand import ShowCliCommandClass

from CliPlugin.BgpCliModels import (
      BgpLuTunnelTable,
      BgpLuPushTunnelTable,
   )
import CliPlugin.RoutingBgpShowCli
from CliPlugin.TunnelCli import (
      tokenTunnelMatcher,
      tunnelIndexMatcher,
   )
from CliToken.RoutingBgpShowCliTokens import (
      bgpAfterShow,
      labeledUnicast,
      noLuPushFlattening,
      push,
   )

# This file provides the CLI parser handling for BGP show commands that are
# about labeled-unicast SAFI

#-------------------------------------------------------------------------------
# "show bgp labeled-unicast tunnel [<tunnel-index>]"
#-------------------------------------------------------------------------------
class ShowBgpLuTunnel( ShowCliCommandClass ):
   syntax = """show bgp labeled-unicast tunnel [ TUNNELIDX_VAL ]"""
   data = {
         "bgp": bgpAfterShow,
         "labeled-unicast": labeledUnicast,
         "tunnel": tokenTunnelMatcher,
         "TUNNELIDX_VAL": tunnelIndexMatcher,
      }
   cliModel = BgpLuTunnelTable

   @staticmethod
   def handler( mode, args ):
      return CliPlugin.RoutingBgpShowCli.showBgpLuTunnelTable(
            mode, tunnelIndex=args.get( "TUNNELIDX_VAL" ) )

addShowCommandClass( ShowBgpLuTunnel )

#-------------------------------------------------------------------------------
# HIDDEN
# "show bgp labeled-unicast tunnel [<tunnel-index>] raw"
#-------------------------------------------------------------------------------
class ShowBgpLuTunnelRaw( ShowCliCommandClass ):
   syntax = """show bgp labeled-unicast tunnel [ TUNNELIDX_VAL ] raw"""
   data = {
         "bgp": bgpAfterShow,
         "labeled-unicast": labeledUnicast,
         "tunnel": tokenTunnelMatcher,
         "TUNNELIDX_VAL": tunnelIndexMatcher,
         "raw": noLuPushFlattening,
      }
   cliModel = BgpLuTunnelTable
   hidden = True

   @staticmethod
   def handler( mode, args ):
      return CliPlugin.RoutingBgpShowCli.showBgpLuTunnelTableNoFlattening(
            mode, tunnelIndex=args.get( "TUNNELIDX_VAL" ) )

addShowCommandClass( ShowBgpLuTunnelRaw )

#-------------------------------------------------------------------------------
# HIDDEN
# "show bgp labeled-unicast push [<tunnel-index>]"
#-------------------------------------------------------------------------------
class ShowBgpLuPush( ShowCliCommandClass ):
   syntax = """show bgp labeled-unicast push [ TUNNELIDX_VAL ]"""
   data = {
         "bgp": bgpAfterShow,
         "labeled-unicast": labeledUnicast,
         "push": push,
         "TUNNELIDX_VAL": tunnelIndexMatcher,
      }
   cliModel = BgpLuPushTunnelTable
   hidden = True

   @staticmethod
   def handler( mode, args ):
      return CliPlugin.RoutingBgpShowCli.showBgpLuPushTunnelTable(
            mode, tunnelIndex=args.get( "TUNNELIDX_VAL" ) )

addShowCommandClass( ShowBgpLuPush )

#-------------------------------------------------------------------------------
# HIDDEN
# "show bgp labeled-unicast push [<tunnel-index>] raw"
#-------------------------------------------------------------------------------
class ShowBgpLuPushRaw( ShowCliCommandClass ):
   syntax = """show bgp labeled-unicast push [ TUNNELIDX_VAL ] raw"""
   data = {
         "bgp": bgpAfterShow,
         "labeled-unicast": labeledUnicast,
         "push": push,
         "TUNNELIDX_VAL": tunnelIndexMatcher,
         "raw": noLuPushFlattening,
      }
   cliModel = BgpLuPushTunnelTable
   hidden = True

   @staticmethod
   def handler( mode, args ):
      return CliPlugin.RoutingBgpShowCli.showBgpLuPushTunnelTableNoFlattening(
            mode, tunnelIndex=args.get( "TUNNELIDX_VAL" ) )

addShowCommandClass( ShowBgpLuPushRaw )
