# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
from __future__ import absolute_import, division, print_function

import CliCommand
import ConfigMount
from CliPlugin.RouterGeneralCli import RouterGeneralMode
from CliPlugin.RouterGeneralCli import routerGeneralCleanupHook
from Toggles import RouteMapToggleLib
import CliToken.RouterGeneralCliTokens

if RouteMapToggleLib.toggleCommandUnconfReferencesRouteMapEnabled():
   config = None

   def setRouteMapPolicyUnconfiguredReferences( enable=False, mode=None ):
      config.routeMapPolicyReferenceUnconfiguredError = enable

   class RouterGeneralCommandReferenceUnconfCli( CliCommand.CliCommandClass ):
      """ @brief This class implements the CLI command:
              'command route-map policy reference unconfigured action error'
          @see aid/6468
      """
      syntax = 'command route-map policy reference unconfigured action error'
      noOrDefaultSyntax = syntax
      data = {
         'command' : CliToken.RouterGeneralCliTokens.cliKeywordCommand,
         'route-map' : CliToken.RouterGeneralCliTokens.cliKeywordRouteMap,
         'policy' : CliToken.RouterGeneralCliTokens.cliKeywordPolicy,
         'reference' : CliToken.RouterGeneralCliTokens.cliKeywordReference,
         'unconfigured' : CliToken.RouterGeneralCliTokens.cliKeywordUnconfigured,
         'action' : CliToken.RouterGeneralCliTokens.cliKeywordAction,
         'error' : CliToken.RouterGeneralCliTokens.cliKeywordError
      }

      @staticmethod
      def handler( mode, args ):
         setRouteMapPolicyUnconfiguredReferences( True )

      @staticmethod
      def noOrDefaultHandler( mode, args ):
         setRouteMapPolicyUnconfiguredReferences( False )

   RouterGeneralMode.addCommandClass( RouterGeneralCommandReferenceUnconfCli )
   routerGeneralCleanupHook.addExtension( setRouteMapPolicyUnconfiguredReferences )

   def Plugin( entityManager ):
      global config
      config = ConfigMount.mount( entityManager,
                                  'routing/routemap/config',
                                  'Routing::RouteMap::Config', 'w' )
