# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliModel
import TableOutput
import ArnetModel

class RouteCounterEntry( CliModel.Model ):
   prefix = ArnetModel.IpGenericPrefix( help='Route Prefix' )
   packetCount = CliModel.Int( help='Packet Count' )
   byteCount = CliModel.Int( help='Byte Count' )

class RouteCounters( CliModel.Model ):
   counters = CliModel.List( valueType=RouteCounterEntry,
                              help='List of prefix counters' )

class VrfRouteCounters( CliModel.Model ):
   vrfs = CliModel.Dict( keyType=str, valueType=RouteCounters,
                           help='A mapping of vrf name to per prefix counters' )

   def render( self ):
      table = TableOutput.createTable( ( 'Vrf Name', 'Prefix', 'Packet Count',
                                         'Byte Count' ) )

      formats = []
      for column in range( 0, 4 ):
         if column == 1:
            f = TableOutput.Format( justify='left' )
         else:
            f = TableOutput.Format( justify='right' )
         f.padLimitIs( True )
         formats.append( f )
      table.formatColumns( f )
      for vrfName in self.vrfs:
         for routeCounterEntry in self.vrfs[ vrfName ].counters:
            table.newRow( vrfName, routeCounterEntry.prefix,
                          routeCounterEntry.packetCount,
                          routeCounterEntry.byteCount )
      print table.output()
