# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import BasicCli
import CliMatcher
from CliPlugin.RouteCacheModels import ThresholdLevels, Summary, VrfPrefix
from CliPlugin.RouteCacheCliLib import cacheKw
from CliPlugin.RouteCacheShowCliLib import runAgentCommand
from CliPlugin.VrfCli import VrfExprFactory
from CliPlugin.IraIpRouteCliLib import prefixMatcher
import ShowCommand

matcherRoute = CliMatcher.KeywordMatcher( 'route', helpdesc='Route information' )

class ShowRouteCacheThreshold( ShowCommand.ShowCliCommandClass ):
   syntax = '''show route cache threshold'''
   data = {
         'route': matcherRoute,
         'cache': cacheKw,
         'threshold': "Display parameters for different threshold levels",
         }
   cliModel = ThresholdLevels
   privileged = True

   @staticmethod
   def handler( mode, args ):
      cliModel = ThresholdLevels
      cmd = "showRouteCacheThreshold"

      return runAgentCommand( mode, cmd, cliModel )

BasicCli.addShowCommandClass( ShowRouteCacheThreshold )

class ShowRouteCacheSummary( ShowCommand.ShowCliCommandClass ):
   syntax = '''show route cache [ VRF ] summary'''
   data = {
         'route': matcherRoute,
         'cache': cacheKw,
         'VRF': VrfExprFactory( helpdesc='Display VRF state', inclAllVrf=True ),
         'summary': "Display route cache summary ",
         }
   cliModel = Summary
   privileged = True

   @staticmethod
   def handler( mode, args ):
      cliModel = Summary
      cmd = "showRouteCacheSummary"
      if args.get( 'VRF' ):
         cmd += '#V' + args.get( 'VRF' )

      return runAgentCommand( mode, cmd, cliModel )

BasicCli.addShowCommandClass( ShowRouteCacheSummary )

class ShowRouteCacheVrfPrefix( ShowCommand.ShowCliCommandClass ):
   syntax = '''show route cache VRF [ PREFIX ]'''
   data = {
         'route': matcherRoute,
         'cache': cacheKw,
         'VRF': VrfExprFactory( helpdesc='Display VRF state', inclAllVrf=True ),
         'PREFIX': prefixMatcher,
         }
   cliModel = VrfPrefix
   privileged = True

   @staticmethod
   def handler( mode, args ):
      cliModel = VrfPrefix
      cmd = "showRouteCacheVrf#V"
      cmd += args[ 'VRF' ]
      if 'PREFIX' in args:
         cmd += '#P' + args[ 'PREFIX' ]

      return runAgentCommand( mode, cmd, cliModel )

BasicCli.addShowCommandClass( ShowRouteCacheVrfPrefix )
