# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import TechSupportCli
from RoutingCommon import GATED_PROTO_SH_TECH_TS

# pylint: disable-msg=F0401

# In the future if we add commands that fork rib to produce their output, then 
# we should split the list of commands into two. One list for commands that don't 
# fork ribd using GATED_PROTO_SH_TECH_TS and the second one for commands that fork
# using GATED_PROTO_FORK_SH_TECH_TS
def _showTechCmds():
   cmds = [ 'show ip rip database',
            'show ip rip neighbors' ]
   return cmds

timeStamp = GATED_PROTO_SH_TECH_TS
TechSupportCli.registerShowTechSupportCmdCallback( timeStamp,
                                                   _showTechCmds )
