# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from DynamicPrefixListCli import routeMapShowCmdDict
from RibCapiLib import showRibCapiCommand
from RibCapiLib import EmptyResponseException
from IpLibConsts import DEFAULT_VRF

def showDynPfxListCb( mode, model, args ):
   command = 'MIO_DGET_DYNAMIC_PREFIX_LIST'
   if args[ 'vrfName' ] == DEFAULT_VRF:
      args.pop( 'vrfName' )
   return showRibCapiCommand( mode, model, command, args )

routeMapShowCmdDict[ 'showDynPfxListCb' ] = showDynPfxListCb
routeMapShowCmdDict[ 'EmptyResponseException' ] = EmptyResponseException
