# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#------------------------------------------------------------------------------------
# This module provides "show rib next-hop resolution route [ipv4|ipv6] (vrf <name>)"
# functions
#------------------------------------------------------------------------------------

import simplejson
import sys
from socket import AF_INET, AF_INET6

from IraCommonCli import ribResolutionRouteHook, ribRouteModel
from IpLibConsts import DEFAULT_VRF
from RibCapiLib import showRibCapiCommand, EmptyResponseException

def showResolutionRibdRoute( af, mode, vrfName ):
   assert 'IpRib' in ribRouteModel

   args = {}
   args[ 'af' ] = AF_INET if af == 'ipv4' else AF_INET6

   if vrfName != DEFAULT_VRF:
      args[ 'vrfName' ] = vrfName

   cmd = "MIO_DGET_RIB_RESOLUTION_ROUTE"

   try:
      model = showRibCapiCommand( mode,
                                  ribRouteModel[ 'IpRib' ].ResolutionRoutes,
                                  cmd, args=args )
   except EmptyResponseException:
      model = ribRouteModel[ 'IpRib' ].ResolutionRoutes()

   if mode.session_.outputFormatIsJson():
      encoder = simplejson.JSONEncoder( indent=4, sort_keys=False )
      for chunk in encoder.iterencode( model.toDict( streaming=True ) ):
         sys.stdout.write( chunk )
      # Output is always newline terminated
      sys.stdout.write( '\n' )
   else:
      model.renderResolutionRoutes( af, vrfName=vrfName )

def Plugin( entityManager ):
   ribResolutionRouteHook.addExtension( showResolutionRibdRoute )
