# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from AgentSnapshotCore import snapshotCoreCallBack
import Tac
import sys

def agentSnapshotCoreHelper( mode, ns, cmd ):
   if not ns:
      Tac.run( [ cmd ], asRoot=True, stdout=sys.stdout,
            stderr=Tac.DISCARD )
   else:
      # Run in specified namespace
      execCmd = [ cmd ]
      netNsCmd = [ "ip", "netns", "exec", ns ]
      netNsCmd.extend( execCmd )
      Tac.run( netNsCmd, asRoot=True, stdout=sys.stdout,
            stderr=Tac.DISCARD )

#-------------------------------------------------------------------------------
# agent Rib snapshot core
#-------------------------------------------------------------------------------
def ribAgentSnapshotCore( mode, ns ):
   cmd = '/usr/bin/RibSnapshot'
   agentSnapshotCoreHelper( mode, ns, cmd )

snapshotCoreCallBack[ 'Rib' ] = ribAgentSnapshotCore

#-------------------------------------------------------------------------------
# agent Isis snapshot core
#-------------------------------------------------------------------------------
def isisAgentSnapshotCore( mode, ns ):
   cmd = '/usr/bin/IsisSnapshot'
   agentSnapshotCoreHelper( mode, ns, cmd )

snapshotCoreCallBack[ 'Isis' ] = isisAgentSnapshotCore

#-------------------------------------------------------------------------------
# agent Ospf snapshot core
#-------------------------------------------------------------------------------
def ospfAgentSnapshotCore( mode, ns ):
   cmd = '/usr/bin/OspfSnapshot'
   agentSnapshotCoreHelper( mode, ns, cmd )

snapshotCoreCallBack[ 'Ospf' ] = ospfAgentSnapshotCore

#-------------------------------------------------------------------------------
# agent Rip snapshot core
#-------------------------------------------------------------------------------
def ripAgentSnapshotCore( mode, ns ):
   cmd = '/usr/bin/RipSnapshot'
   agentSnapshotCoreHelper( mode, ns, cmd )

snapshotCoreCallBack[ 'Rip' ] = ripAgentSnapshotCore
