#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import ShowCommand
import Url
import CliPlugin.VersionCompatibilityCli as VersionCompatibilityCli

#--------------------------------------------------------------------------------
# show version compatibility SWI
#--------------------------------------------------------------------------------
class VersionCompatibilityCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show version compatibility SWI'
   data = {
      'version': 'Software and hardware versions',
      'compatibility': 'Check software image version compatibility',
      'SWI' : Url.UrlMatcher(
         fsFunc=lambda fs: fs.scheme in [ 'file:', 'flash:' ],
         helpdesc='Software image URL' ),
   }
   handler = VersionCompatibilityCli.showVersionCompatibility
   cliModel = VersionCompatibilityCli.VersionCompatibility

BasicCli.addShowCommandClass( VersionCompatibilityCmd )
