#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import ShowCommand
import CliToken.Redundancy as Redundancy
import CliPlugin.RedSupCli as RedSupCli
from CliPlugin.FileReplicationModels import RequesterStatus
from CliPlugin.RedSupModels import SsoSwitchoverLogs, RedundancyStates
from CliMatcher import KeywordMatcher

#--------------------------------------------------------------------------------
# show redundancy file-replication
#--------------------------------------------------------------------------------
class RedundancyFileReplicationCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show redundancy file-replication'
   data = {
      'redundancy': Redundancy.redundancyForShowGuarded,
      'file-replication': 'Display supervisor file replication status'
   }
   handler = RedSupCli.doShowRedFileRep
   cliModel = RequesterStatus

BasicCli.addShowCommandClass( RedundancyFileReplicationCmd )

#--------------------------------------------------------------------------------
# show redundancy states command ( deprecated )
#--------------------------------------------------------------------------------
class RedundancyStatesCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show redundancy states'
   data = {
      'redundancy': Redundancy.redundancyForShowGuarded,
      'states': CliCommand.Node( KeywordMatcher( 'states',
         helpdesc='Redundancy states (deprecated)' ),
         deprecatedByCmd='show redundancy status' )
   }
   handler = RedSupCli.doShowRedStatus
   cliModel = RedundancyStates

BasicCli.addShowCommandClass( RedundancyStatesCmd )

#--------------------------------------------------------------------------------
# show redundancy status
#--------------------------------------------------------------------------------
class RedundancyStatusCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show redundancy status'
   data = {
      'redundancy': Redundancy.redundancyForShowGuarded,
      'status': 'Redundancy status',
   }
   handler = RedSupCli.doShowRedStatus
   cliModel = RedundancyStates

BasicCli.addShowCommandClass( RedundancyStatusCmd )

#--------------------------------------------------------------------------------
# show redundancy switchover sso
#--------------------------------------------------------------------------------
class RedundancySwitchoverSsoCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show redundancy switchover sso'
   data = {
      'redundancy': Redundancy.redundancyForShowGuarded,
      'switchover': 'Switchover information',
      'sso': 'Stateful switchover information',
   }
   handler = RedSupCli.doShowSwitchoverSsoLog
   cliModel = SsoSwitchoverLogs

BasicCli.addShowCommandClass( RedundancySwitchoverSsoCmd )

#--------------------------------------------------------------------------------
# show redundancy time-sync
#--------------------------------------------------------------------------------
class RedundancyTimeSyncCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show redundancy time-sync'
   data = {
      'redundancy': Redundancy.redundancyForShowGuarded,
      'time-sync': 'Display status of time-sync',
   }
   handler = RedSupCli.doShowTimeSyncStatus

BasicCli.addShowCommandClass( RedundancyTimeSyncCmd )

