#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliPlugin.RedSupCli as RedSupCli
import Url

#--------------------------------------------------------------------------------
# [ no | default ] path URL
#--------------------------------------------------------------------------------
class PathCmd( CliCommand.CliCommandClass ):
   syntax = 'path URL'
   noOrDefaultSyntax = syntax
   data = {
      'path' : 'Specify file URL to replicate',
      'URL' : Url.UrlMatcher( lambda fs:
                              ( fs.fsType == 'flash' and
                                fs.scheme in ( 'flash:', 'drive:' ) ),
                              'Local file URL' )
   }
   handler = RedSupCli.addFileReplPath
   noOrDefaultHandler = RedSupCli.removeFileReplPath

RedSupCli.RedundancyFileReplMode.addCommandClass( PathCmd )
