#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliPlugin.RedSupCli as RedSupCli
import CliToken.Redundancy as Redundancy

#--------------------------------------------------------------------------------
# redundancy
# Always register the redundancy config mode so we can parse the command
# in startup-config. The guard on redundancy should make sure it's not
# usable on fixed-systems.
#--------------------------------------------------------------------------------
class RedundancyCmd( CliCommand.CliCommandClass ):
   syntax = 'redundancy'
   data = {
      'redundancy': Redundancy.redundancyForGlobalConfigGuarded,
   }
   handler = RedSupCli.gotoRedundancyMode

BasicCliModes.GlobalConfigMode.addCommandClass( RedundancyCmd )
