#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliPlugin.RedSupCli as RedSupCli
import CliPlugin.SupeSessionCli as SupeSessionCli
import CliToken.Redundancy as Redundancy
from CliMatcher import KeywordMatcher, StringMatcher

#--------------------------------------------------------------------------------
# redundancy force switchover - deprecated command
# redundancy manual switchover
#--------------------------------------------------------------------------------
class RedundancySwitchoverCmd( CliCommand.CliCommandClass ):
   syntax = 'redundancy ( force-switchover | ( manual switchover ) )'
   data = {
      'redundancy': Redundancy.redundancyForExecGuarded,
      'force-switchover': CliCommand.Node( KeywordMatcher( 'force-switchover',
         helpdesc='Force a manual switchover' ),
         deprecatedByCmd='redundancy manual switchover' ),
      'manual': 'Manual commands',
      'switchover': 'Force a manual switchover',
   }
   handler = RedSupCli.doRedForceSwitchover

BasicCliModes.EnableMode.addCommandClass( RedundancySwitchoverCmd )

#--------------------------------------------------------------------------------
# session peer-supervisor [ CMD ]
#--------------------------------------------------------------------------------
class SessionPeerSupervisorCmd( CliCommand.CliCommandClass ):
   syntax = 'session peer-supervisor [ CMD ]'
   data = {
      'session': 'Start a CLI session',
      'peer-supervisor': CliCommand.Node( KeywordMatcher( 'peer-supervisor',
         helpdesc='Start CLI session on the peer supervisor' ),
         guard=RedSupCli.supervisorRedundancyGuard ),
      'CMD': StringMatcher( helpname='COMMAND',
         helpdesc='Command to be run' ),
   }
   handler = SupeSessionCli.runCliOnPeerSupe

BasicCliModes.EnableMode.addCommandClass( SessionPeerSupervisorCmd )

