#!/usr/bin/env python
# Copyright (c) 2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliSession
import Fru
import FruCli

em = None

def getShortRedundancy( session=None ):
   mode = em.redundancyStatus().mode
   if mode == 'active':
      return ''
   else:
      return '(%s)' % mode

def getFullRedundancy( session=None ):
   mode = em.redundancyStatus().mode
   if mode == 'active':
      redundancyStr = ''
   else:
      redundancyStr = '-%s' % mode
   return '(s%d%s)' % ( Fru.slotId(), redundancyStr )

def registerPrompt():
   BasicCliSession.addFormatSpecifier( 'r', getShortRedundancy )
   BasicCliSession.addFormatSpecifier( 'R', getFullRedundancy )

def Plugin( entityManager ):
   global em
   em = entityManager

FruCli.registerModularSystemCallback( registerPrompt )
