# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ConfigMount
import LagCli
import LazyMount
import Tracing

traceHandle = Tracing.Handle( 'RecircCli' )
t0 = traceHandle.trace0

# Globals written by the Plugin function at the end of this file
lagIntfConfigDir = None
recircFeatureStatus = None

isRecirc = LagCli.isRecirc

#-------------------------------------------------------------------------------
# Rule to match the token <recircChannelGroup_id list>, returning a list of
# corresponding RecircChannelGroup objects.
#-------------------------------------------------------------------------------

def recircChannelGroups( match ):
   # match is idList
   return map( LagCli.RecircChannelGroup, match )

#-------------------------------------------------------------------------------
# The "show recirc-channel" command, in "enable" mode.
#
# The full syntax of this command is:
#
#   show recirc-channel <recircChannelGroupIdList> [ active-ports |
#                                                    all-ports |
#                                                    brief |
#                                                    detailed |
#                                                    traffic |
#                                                    <RecircChannelGroupID> ]
#-------------------------------------------------------------------------------

def recircChannelList( mode, recircChannelGroupId ):
   return LagCli.portchannelList( mode, recircChannelGroupId, lacpOnly=False,
                                  filterFunc=isRecirc )

def doShowRecircChannel( mode, args ):
   recircChannelGroupIdList = LagCli.getRecircGroupIdList( args.get( 'INTFS' ) )
   brief = 'detailed' not in args
   allPorts = 'active-ports' not in args
   channels = recircChannelList( mode, recircChannelGroupIdList )
   return LagCli.doShowChannelGroups( mode, channels, brief, allPorts )

def doShowRecircChannelTraffic( mode, args ):
   recircChannelGroupIdList = LagCli.getRecircGroupIdList( args.get( 'INTFS' ) )
   lagDict = LagCli.getLagMemberDict( mode, recircChannelGroupIdList, 
                                      filterFunc=isRecirc )
   return LagCli.doShowChannelGroupTraffic( mode, lagDict )


def doShowRecircChannelLimits( mode, args ):
   limits = 'limits' in args
   return LagCli.doShowChannelLimits( mode, channelType='recirc-channel', 
                                      limits=limits )

#-------------------------------------------------------------------------------
# Have the Cli Agent mount all needed state from sysdb
#-------------------------------------------------------------------------------
def Plugin( entityManager ):
   global lagIntfConfigDir, recircFeatureStatus

   lagIntfConfigDir = ConfigMount.mount( entityManager, "interface/config/eth/lag",
                                       "Interface::EthLagIntfConfigDir", "w" )
   recircFeatureStatus = LazyMount.mount( entityManager, "lag/recirc/status",
                                          "Lag::Recirc::RecircFeatureStatus", "r" )
