# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Bool
from CliModel import Model
from CliModel import Str
from CliModel import List

class ShowRcfPendingModel( Model ):
   """
   Models the RCF pending contents (scratchpad)
   """
   pendingChanges = Bool( help='There are pending routing control function changes' )
   rcfCode = Str( optional=True, help='Pending routing control function code' )
   url = Str( optional=True, help='Source file URL' )

   def render( self ):
      if self.pendingChanges:
         if self.rcfCode:
            if self.url:
               print "! Source: ", self.url
            print self.rcfCode
         else:
            print "All routing control functions are pending deletion"
      else:
         print "No pending routing control function changes"

class ShowRcfErrorsStartupModel( Model ):
   """
   Models compilation errors that may occur during startup config
   """
   active = Bool( help='Routing control functions are active' )
   compilationErrors = \
         List( valueType=str, help='Routing control function startup config errors' )

   def render( self ):
      if self.active:
         # no error to print
         print 'no startup routing control function errors'
      else:
         for error in self.compilationErrors:
            print error
