#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliMatcher
import LazyMount

rcfStatus = None

#----------------------------------------------------------------------------------
#                                K E Y W O R D S
#----------------------------------------------------------------------------------

rcfKw = CliMatcher.KeywordMatcher( 'rcf', helpdesc="Routing control function" )

#----------------------------------------------------------------------------------
#                                M A T C H E R S
#----------------------------------------------------------------------------------

def getExistingFunctionNames( mode ):
   return [ ( func[ 0 ] + "()" ) for func in rcfStatus.functionNames.items() ]

rcfFunctionMatcher = CliMatcher.DynamicNameMatcher(
         getExistingFunctionNames,
         helpdesc="Routing control function name",
         pattern=r'([A-Za-z0-9_])([A-Za-z0-9_]*)\(\)', helpname='FUNCNAME()' )

#-------------------------------------------------------------------------------
#                                P L U G I N
#-------------------------------------------------------------------------------
def Plugin( entityManager ):
   global rcfStatus

   rcfStatus = LazyMount.mount( entityManager,
                                'routing/rcf/status',
                                'Rcf::Status', 'r' )
