#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import BasicCliModes
import CliCommand
import CliMatcher
import ConfigMount
import ShowCommand
import Tac
from CliPlugin.SnmpCli import (
      snmpServerKwMatcher,
      snmpKwMatcher,
      mibKwMatcherForShow
      )
import CliModel

qosMibConfig = None

#--------------------------------------------------------------------------------
# show snmp mib qosmib counter-interval
#--------------------------------------------------------------------------------
class QosmibCounterIntervalModel( CliModel.Model ):
   enabled = CliModel.Bool( help="QOS-MIB counters are enabled" )
   interval = CliModel.Int( help="QOS-MIB counter update interval (seconds)" )

   def render( self ):
      if self.enabled:
         print "Updates to QOS counters will be triggered every:", \
               self.interval, "seconds."
      else:
         print "QOS counter updates are not enabled."

class SnmpMibQosmibCounterIntervalCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show snmp mib qosmib counter-interval'
   data = {
      'snmp': snmpKwMatcher,
      'mib': mibKwMatcherForShow,
      'qosmib': 'Show SNMP QOS-MIB contents',
      'counter-interval': 'Show QOS-MIB counter update interval',
   }

   @staticmethod
   def handler( mode, args ):
      ret = QosmibCounterIntervalModel()
      ret.enabled = qosMibConfig.counterUpdateInterval != Tac.endOfTime
      if ret.enabled:
         ret.interval = int( qosMibConfig.counterUpdateInterval )
      else:
         ret.interval = 0       # ignored
      return ret
   privileged = True
   cliModel = QosmibCounterIntervalModel

BasicCli.addShowCommandClass( SnmpMibQosmibCounterIntervalCmd )

#--------------------------------------------------------------------------------
# snmp-server qosmib counter-interval UPDATE_INTERVAL
#--------------------------------------------------------------------------------
class SnmpServerQosmibCounterIntervalUpdateintervalCmd( CliCommand.CliCommandClass ):
   syntax = 'snmp-server qosmib counter-interval UPDATE_INTERVAL'
   noOrDefaultSyntax = 'snmp-server qosmib counter-interval ...'
   data = {
      'snmp-server': snmpServerKwMatcher,
      'qosmib': 'Set SNMP QOS-MIB parameters',
      'counter-interval': 'Set QOS-MIB counter update interval',
      'UPDATE_INTERVAL': CliMatcher.IntegerMatcher( 10, 600,
            helpdesc='update interval for refreshing QoS counters (in seconds)' ),
   }

   @staticmethod
   def handler( mode, args ):
      qosMibConfig.counterUpdateInterval = args.get( 'UPDATE_INTERVAL',
                                                     Tac.endOfTime )

   noOrDefaultHandler = handler

BasicCliModes.GlobalConfigMode.addCommandClass(
         SnmpServerQosmibCounterIntervalUpdateintervalCmd )

#--------------------------------------------------------------------------------
def Plugin( entityManager ):
   global qosMibConfig
   qosMibConfig = ConfigMount.mount( entityManager, "snmp/qos/config",
                                     "QosSnmp::QosMibConfig", "w" )
