#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.QosCli as QosCli
import CliPlugin.QosCliCopp as QosCliCopp
from CliToken.Clear import clearKwNode

matcherPolicyMap = CliMatcher.KeywordMatcher( 'policy-map',
   helpdesc='Clear Policy Map' )
nodePolicyMap = CliCommand.Node( matcher=matcherPolicyMap,
   guard=QosCli.guardPolicyMap )

#--------------------------------------------------------------------------------
# clear policy-map interface control-plane counters copp-system-policy
#--------------------------------------------------------------------------------
class ClearPMapIntfCtrlPlaneCountersCoppSysPolicyCmd( CliCommand.CliCommandClass ):
   syntax = 'clear policy-map interface control-plane counters copp-system-policy'
   data = {
      'clear': clearKwNode,
      'policy-map': nodePolicyMap,
      'interface': CliCommand.Node( matcher=CliMatcher.KeywordMatcher( 'interface',
         helpdesc='Service Policy on interface' ), guard=QosCliCopp.guardPMapCopp ),
      'control-plane': CliCommand.Node( matcher=CliMatcher.KeywordMatcher(
         'control-plane', helpdesc='Control-plane type' ),
         guard=QosCliCopp.guardPMapCopp ),
      'counters': 'Policy Map counters',
      'copp-system-policy': CliCommand.Node( matcher=CliMatcher.KeywordMatcher(
         'copp-system-policy', helpdesc='Copp Policy-map name' ),
         guard=QosCliCopp.guardCoppSystemPolicy ),
   }
   handler = QosCli.clearPMapIntfCounters

BasicCliModes.EnableMode.addCommandClass(
   ClearPMapIntfCtrlPlaneCountersCoppSysPolicyCmd )

#--------------------------------------------------------------------------------
# clear policy-map type qos [ PMAPNAME ] counters
#--------------------------------------------------------------------------------
class ClearPolicyMapTypeQosCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear policy-map type qos [ PMAPNAME ] counters'
   data = {
      'clear': clearKwNode,
      'policy-map': nodePolicyMap,
      'type': 'Specify type',
      'qos': CliCommand.Node( matcher=CliMatcher.KeywordMatcher( 'qos',
         helpdesc='Qos type' ), guard=QosCli.guardPMapQos ),
      'PMAPNAME': CliMatcher.DynamicNameMatcher( QosCli.getPMapNameQos,
         'Policy Map Name',
         pattern='(?!counters$|interface$|summary$)[A-Za-z0-9_:{}\\[\\]-]+' ),
      'counters': 'Policy Map counters',
   }
   handler = QosCli.clearPMapIntfCounters

BasicCliModes.EnableMode.addCommandClass( ClearPolicyMapTypeQosCountersCmd )
