# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import IntfCli
import IntfModels
import Tac

from CliModel import Int
from CliModel import Dict
from CliModel import Enum
from CliModel import List
from CliModel import Model

class VlanPrivateVlan( Model ):
   class PrivateVlans( Model ):
      class PrivateVlan( Model ):
         secondaryVlanId = Int( help="The secondary VLAN Id" )
         vlanType = Enum( values=Tac.Type( "Bridging::VlanType" ).attributes, 
                          help="The type of Private VLAN" )
         interfaces = List( valueType=IntfModels.Interface, 
                            help="List of interfaces in VLAN" )
      privateVlan = List( valueType=PrivateVlan, 
                          help="A list of the private VLAN information" )
   privateVlans = Dict( keyType=int, valueType=PrivateVlans, 
                        help="A mapping between a primary VLAN Id and a list of "
                             "private VLAN information" )
   
   def render( self ):
      fmt = '%-7s %-9s %-11s'
      print 'Primary Secondary Type        Ports'
      print '------- --------- ----------- -------------------------------'
      
      for primaryVlan in sorted( self.privateVlans ):
         for privateVlan in self.privateVlans[ primaryVlan ].privateVlan:
            print fmt % ( primaryVlan,
                          privateVlan.secondaryVlanId,
                          privateVlan.vlanType ),
            if not privateVlan.interfaces:
               print
            else:
               # Print the list of ports that are members of primary/secondary VLANs.
               # If the list is too long to fit on one line, wrap it onto
               # subsequent lines.
               prefix = ' ' * len( fmt % ( 1, '', '' ) )
               firstLine = True
               portNames = []
               for port in privateVlan.interfaces:
                  portNames.append( IntfCli.Intf.getShortname( port ) )
               portsLine = portNames[ 0 ]
               for portName in portNames[ 1: ]:
                  if len( portsLine ) + len( ', ' ) + len( portName ) > 31:
                     if not firstLine:
                        print prefix,
                     print portsLine
                     firstLine = False
                     portsLine = ''
                  else:
                     portsLine += ', '
                  portsLine += portName
               if not firstLine:
                  print prefix,
               print portsLine

