# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from CliModel import Model, Dict, Float

class Match( Model ):
   timestamp = Float( help="Pulse Counter timestamp" )
   counters = Dict( valueType=long,
                    help="A mapping between counter name and counter value" )

   def render( self ):
      # compute the longest counter.key in the container
      largestKeyLen = 0
      for counterKey in self.counters:
         keyLen = len( counterKey )
         if keyLen > largestKeyLen:
            largestKeyLen = keyLen

      # print the header based on the longest counter.key
      hdr = 'Counter'
      if largestKeyLen < len( hdr ):
         largestKeyLen = len( hdr )

      totalHdr = hdr + ' ' * ( largestKeyLen - len( hdr ) ) + '  Value'
      print( totalHdr )
      print( '-' * largestKeyLen + '  -----' )

      # now dump all the counters, in sorted order
      sortedKeys = sorted( self.counters )
      for counterKey in sortedKeys:
         keyLen = len( counterKey )
         print( counterKey + ' ' * ( largestKeyLen - keyLen ) + \
             '  %u' % self.counters[ counterKey ] )
