#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import TacPulse
import PulseCliModel
import Tac, re

lib = TacPulse.ReaderLib()
defaultCounter = Tac.Value( 'TacPulse::Counter' )
agentConfig = None

def printMatches( mode, args ):
   matchName = args.get( 'MATCHNAME', '' )
   match = PulseCliModel.Match()
   results = lib.findall( matchName )
   for result in results:
      parsed = re.search( r'(\S+) : (\d+)', result )
      count = long( parsed.group( 2 ) )
      match.counters[ parsed.group( 1 ) ] = count
   match.timestamp = Tac.now()
   return match

def printCounter( mode, args ):
   match = PulseCliModel.Match()
   for counterName in args[ 'COUNTERS' ]:
      ( pulse, name ) = tuple( counterName.split( '/' ) )
      counter = lib.counter( pulse, name )
      if len( counter.key ) == 0:
         continue
      count = long( counter.count )
      match.counters[ counterName ] = count
   match.timestamp = Tac.now()
   return match
