#!/usr/bin/env python
# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac, IntfCli, ConfigMount, Tracing

__defaultTraceHandle__ = Tracing.Handle( 'PtpCli' )
t8 = Tracing.trace8

ptpConfig = None

class PtpIntfJanitor( IntfCli.IntfDependentBase ):
   def setDefault( self ):
      del ptpConfig.intfConfig[ self.intf_.name ]


def Plugin( entityManager ):
   global ptpConfig
   ptpConfig = ConfigMount.mount( entityManager, "ptp/config", "Ptp::Config", "w" )
   IntfCli.Intf.registerDependentClass( PtpIntfJanitor, priority=10 )
