#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import CliMatcher
import ShowCommand
import CliPlugin.PowerCli as PowerCli
from CliPlugin.PowerCli import PowerSupplies, VoltageSensors
from CliToken.System import systemMatcherForShow

matcherDetail = CliMatcher.KeywordMatcher( 
      'detail', helpdesc='Show detailed system power status' )
matcherEnvironment = CliMatcher.KeywordMatcher( 
      'environment', helpdesc='Show system environment status' )
matcherPower = CliMatcher.KeywordMatcher( 
      'power', helpdesc='Show system power status' )
matcherVoltage = CliMatcher.KeywordMatcher( 
      'voltage', helpdesc='Show voltage sensor values' )

#--------------------------------------------------------------------------------
# show environment power
#--------------------------------------------------------------------------------
class EnvironmentPowerCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show environment power'
   data = {
      'environment': matcherEnvironment,
      'power': matcherPower,
   }
   handler = PowerCli.showPower
   cliModel = PowerSupplies

BasicCli.addShowCommandClass( EnvironmentPowerCmd )

#--------------------------------------------------------------------------------
# show environment power detail
#--------------------------------------------------------------------------------
class EnvironmentPowerDetailCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show environment power detail'
   data = {
      'environment': matcherEnvironment,
      'power': matcherPower,
      'detail': matcherDetail,
   }
   handler = PowerCli.showPowerDetail
   cliModel = PowerSupplies

BasicCli.addShowCommandClass( EnvironmentPowerDetailCmd )

#--------------------------------------------------------------------------------
# show environment power voltage
#--------------------------------------------------------------------------------
class EnvironmentPowerVoltageCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show environment power voltage'
   data = {
      'environment': matcherEnvironment,
      'power': matcherPower,
      'voltage': matcherVoltage,
   }
   handler = PowerCli.showPowerVoltage
   cliModel = VoltageSensors

BasicCli.addShowCommandClass( EnvironmentPowerVoltageCmd )

#--------------------------------------------------------------------------------
# show system environment power
#--------------------------------------------------------------------------------
class SystemEnvironmentPowerCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show system environment power'
   data = {
      'system': systemMatcherForShow,
      'environment': matcherEnvironment,
      'power': matcherPower,
   }
   handler = PowerCli.showPower
   cliModel = PowerSupplies

BasicCli.addShowCommandClass( SystemEnvironmentPowerCmd )

#--------------------------------------------------------------------------------
# show system environment power detail
#--------------------------------------------------------------------------------
class SystemEnvironmentPowerDetailCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show system environment power detail'
   data = {
      'system': systemMatcherForShow,
      'environment': matcherEnvironment,
      'power': matcherPower,
      'detail': matcherDetail,
   }
   handler = PowerCli.showPowerDetail
   cliModel = PowerSupplies

BasicCli.addShowCommandClass( SystemEnvironmentPowerDetailCmd )

#--------------------------------------------------------------------------------
# show system environment power voltage
#--------------------------------------------------------------------------------
class SystemEnvironmentPowerVoltageCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show system environment power voltage'
   data = {
      'system': systemMatcherForShow,
      'environment': matcherEnvironment,
      'power': matcherPower,
      'voltage': matcherVoltage,
   }
   handler = PowerCli.showPowerVoltage
   cliModel = VoltageSensors

BasicCli.addShowCommandClass( SystemEnvironmentPowerVoltageCmd )
